function ValidateBuildParams()
%% Make sure that we compile Arachne with correct parameters

    global remoteHPC debugMode
    
    assert(ispc);
    
    demoMode = VeryBasicParams();
    assert(remoteHPC && ~demoMode && ~debugMode);
    
    % Make sure that we have the toolbox used by Dashboard GUI
    reqToolboxName = 'Widgets Toolbox';
    toolboxes = matlab.addons.toolbox.installedToolboxes;
    found = false;
    for i = 1 : length(toolboxes)
        if strcmp(toolboxes(i).Name, reqToolboxName)
            found = true;
            break
        end
    end
    msgPat = '\nPlease install <a href="https://www.mathworks.com/matlabcentral/fileexchange/66235-widgets-toolbox">%s</a>';
    assert(found, msgPat, reqToolboxName);
    
end
