function CREATE_HostInstaller()
%% Create an installer for "START_INSTALLED_Arachne.m" entry point.
%  In addition to the compiled m-code, the installer deploys all necessary non-M files (e.g. BAT-scripts)
%  and downloads/installs Matlab Runtime if it's missing on the PC.
%  Known issues/features of the installer:
%  1. The installer fails with "Error finding installer class" if %USERNAME% environment variable contains non-ASCII characters or spaces.
%     As a workaround, you need to create a new Windows user with proper name and install Arachne under that user.
%     Notice that there is an "official" workaround proposed by MathWorks Support Team (changing values of %TEMP% and %TMP%), but it does not work for me:
%     https://www.mathworks.com/matlabcentral/answers/92499-why-do-i-receive-a-message-stating-error-finding-installer-class-when-trying-to-install-matlab-on
%     After the installation, the application can be run successfully or uninstalled under any user.
%  2. The installer fails with "Call to download server failed" error if there is no Internet connection.
%     The connection is a must even if Matlab Runtime was installed before.
%  3. The installer does not warn user if Arachne was already installed on the PC.
%     It simply replaces it even though a higher version was installed.
%  4. The installer fails with "The specified path does not exist" error if it is launched from a subst'ed drive.
%  5. When user launches the installed application for the first time, there is a long pause before the main menu GUI shows up.
%  6. The uninstaller leaves some content in the Arachne installation folder (however, it informs user about that).

    AddPaths(true);
    
    % Make sure that we compile Arachne with correct parameters
    ValidateBuildParams();
    
    % Deploy all needed non-M files to a new temporary directory
    outDirName = 'host_installer';
    tempSubDirName = '_InstallerTemp';
    % outDirPath = ...
    PrepareEmptyDirDeployNonMFiles(outDirName, tempSubDirName);
    
    % Create the installer
    % (the next command starts a process which returns shortly, but works in background for a few minutes after the call)
    applicationCompiler('-package', 'Arachne.prj');
    
    % We would delete the temporary subdirectory once the installer is ready,
    % but, unfortunately, we cannot determine that moment of time in a simple way
    % rmdir(fullfile(outDirPath, tempSubDirName), 's');
    
end