function demoMode = VeryBasicParams()
%% Initialize the very basic parameters, i.e. the parameters that must be validated before compiling Arachne

    global remoteHPC debugMode
    
    % Whether to conduct simulation on remote HPC cluster (for not installed mode only)
    remoteHPC = true;
    
    % Whether to use only the master node of the cluster (for "win-lin" mode only)
    demoMode = false;
    
    % Whether to turn on the debug mode:
    % 1. MOD files are always translated to C++ code (independently on MD5-code);
    % 2. HPC kernel is always built;
    % 3. HPC kernel is built in Debug configuration instead of Release (for "win-win" mode only);
    % 4. Exceptions are not caught (so call stack is printed to console each time).
    debugMode = false;
    
end
