function ComputeMaxModelSize(varargin)
%% Common entry point for both desktop and mobile versions of Matlab

    % Clear all variables, but do not remove breakpoints
    clearvars -except varargin;
    clearvars -global -except mobileMode installedMode hostDirPaths;
    
    close all;
    
    clc;
    
    global pushbutton_OK_Delegate
    global guiType GuiTypes
    
    BasicParams(varargin{:});
    
    guiType = GuiTypes.UtilityComputeMaxModelSize;
    pushbutton_OK_Delegate = @SCRIPT_Core;
    
    PrepareAndShowGUI();
    
end

function SCRIPT_Core()

    global setIter i2eRatio num_e num_i mobileMode
    
    setIter = true;
    
    MaxModelSize(i2eRatio);
    
    [~, estMsg, limMsg] = CountTotalMemReq();
    
    msgPat = ['Maximum number of e-neurons: %i\n', ...
              'Maximum number of i-neurons: %i\n', ...
              '%s\n%s'];
    msg = sprintf(msgPat, num_e, num_i, estMsg, limMsg);
    
    fprintf('%s\n\n', msg);
    
    if ~mobileMode
        % !! use helpdlg (but it nonmodal)?
        msgbox(msg, 'The maximum model size', 'help', 'modal');
        beep();
    end
    
end
