function stdpMatrix = ReadValidateStdpFile(stdpFile, suffix)
%% Read and validate tabulated STDP model file

    absFilePath = PrepareStdpFileAbsPath(stdpFile);
    
    % Read the file
    try
        % Remark: the behaviour of this function with regard to malformed files is not intuitive in some cases, e.g.
        % "0.12"  -> 0.12
        % "0.1a2" -> 0.1
        % "a0.12" -> exception
        stdpMatrix = dlmread(absFilePath);
    catch ex
        error(DecorateMessage(ex.message));
    end
    
    numRows = size(stdpMatrix, 1);
    numCols = size(stdpMatrix, 2);
    assert(numRows > 1, DecorateMessage('The number of rows is less than 2'));
    assert(numCols == 2, DecorateMessage('The number of columns does not equal 2'));
    
    time = stdpMatrix(:, 1);
    
    % Check that 1st column contains equidistant ascending values
    ulp = 100;
    tol = ulp * eps(max(time));
    d = diff(time);
    assert(max(d) - min(d) < tol, DecorateMessage('The first column does not contain equidistant values'));
    assert(d(1) > 0, DecorateMessage('The first column does not contain ascending values'));
    
    % Nested helper function
    function msg = DecorateMessage(msg)
        msg = ['stdpFile_', suffix, ':', newline, ...
               absFilePath, newline, newline, ...
               msg];
    end
    
end
