function lines = ProcessIncludeDirectivesRecursively(lines, cline, dirPath)

    if contains(cline, 'INCLUDE')
        scopeIdx = strfind(cline, '"');
        includeFileName = cline(scopeIdx(1) + 1 : scopeIdx(end) - 1);
        fInclude = fopen(fullfile(dirPath, includeFileName), 'r');
        if fInclude == -1
            error('Cannot open include file for reading');
        end
        while ~feof(fInclude)
            tline = fgetl(fInclude);
            
            if contains(tline, 'INCLUDE')
                lines = ProcessIncludeDirectivesRecursively(lines, tline, dirPath);
            else
                lines{end + 1, 1} = tline; %#ok<AGROW>
            end
        end
        fclose(fInclude);
    else
        lines{end + 1, 1} = cline;
    end
    
end