function [blocks, freeLocalVars] = ParseModFile(filePathName)
%%

    modKeywords = {
        'TITLE', ...
        'NEURON', ...
        'CONSTANT', ...
        'PARAMETER', ...
        'UNITS', ...
        'ASSIGNED', ...
        'STATE', ...
        'BREAKPOINT', ...
        'INITIAL', ...
        'FUNCTION', ...
        'DERIVATIVE', ...
        'PROCEDURE', ...
        'KINETIC', ...
        'DEFINE'};

    modFile = fopen(filePathName);
    if modFile == -1
        error('Cannot open file for reading');
    end

    blocks = RunIncludePreprocessor(filePathName, modKeywords);

    numBlocks = zeros(size(modKeywords));

    line = fgetl(modFile);

    while ischar(line) || isempty(line)

        found = false;
        for idx = 1 : length(modKeywords)

            if ischar(line) && contains(line, modKeywords{idx})

                found = true;

                lines = {};
                lines{end + 1, 1} = line; %#ok<AGROW>
                line = fgetl(modFile);

                while ischar(line) || isempty(line)

                    containKeyword = false;

                    for j = 1 : length(modKeywords)
                        if contains(line, modKeywords{j}) && ~contains(line, 'UNITSOFF')
                            containKeyword = true;
                            break
                        end
                    end

                    if containKeyword
                        break
                    end

                    lines{end + 1, 1} = line; %#ok<AGROW>

                    line = fgetl(modFile);

                end

                numBlocks(idx) = numBlocks(idx) + 1;

                rigthBorder = 1;
                lenLines = length(lines);
                for k = 0 : lenLines - 1
                    if contains(lines{lenLines - k}, '}')
                        rigthBorder = lenLines - k;
                        break
                    end
                end

                cleanLines = {};

                for k = 1 : rigthBorder
                    cleanLines{end + 1, 1} = lines{k}; %#ok<AGROW>
                end

                if strcmp(modKeywords{idx}, 'PROCEDURE') || strcmp(modKeywords{idx}, 'FUNCTION')
                    field = blocks.(modKeywords{idx});
                    field{numBlocks(idx)} = cleanLines;
                    blocks.(modKeywords{idx}) = field;
                else
                    blocks.(modKeywords{idx}) = cleanLines;
                end
                
            end
        end
        if ~found
            line = fgetl(modFile);
        end
    end
    
    fclose(modFile);
    
    freeLocalVars = GetFreeLocalVars(filePathName);
    
end

function blocks = RunIncludePreprocessor(filePathName, modKeywords)
%%

    modFile = fopen(filePathName, 'r');
    if modFile == -1
        error('Cannot open file for reading');
    end
    
    blocks = struct();
    for idx = 1 : length(modKeywords)
        blocks.(modKeywords{idx}) = {};
    end
    
    dirPath = fileparts(filePathName);
    
    lines = {};
    while ~feof(modFile)
        
        line = fgetl(modFile);
        keywordsIdx = -1; %#ok<NASGU>
        if contains(line, 'INCLUDE')
            idx = strfind(line, '"');
            leftIdx = idx(1) + 1;
            rightIdx = idx(end) - 1;

            nameIncludeFile = line(leftIdx : rightIdx);
            pathToIncludeMod = fullfile(dirPath, nameIncludeFile);
            
            includeLines = ProcessIncludeDirective(pathToIncludeMod);
            
            found = false;
            for k = 1 : length(includeLines)
                line = includeLines{k};
                if ~found
                    for idx = 1 : length(modKeywords)
                        if contains(line, modKeywords{idx})
                            keywordsIdx = idx; %#ok<NASGU>
                            found = true;
                            break
                        end
                    end
                end
                
                if found
                    lines{end + 1, 1} = line; %#ok<AGROW>
                end
            end
            
            if strcmp(modKeywords{idx}, 'PROCEDURE') || strcmp(modKeywords{idx}, 'FUNCTION')
                field = blocks.(modKeywords{idx});
                field{end + 1} = lines; %#ok<AGROW>
                blocks.(modKeywords{idx}) = field;
            else
                blocks.(modKeywords{idx}) = lines;
            end
    
            lines = {};
        end
    end
    
    fclose(modFile);
    
end

function lines = ProcessIncludeDirective(filePathName)
%%

    dirPath = fileparts(filePathName);
    lines = {};
    fid = fopen(filePathName);
    if fid == -1
        error('Couldn''t open the next file for reading:\n%s', filePathName);
    end
    while ~feof(fid)
        cline = fgetl(fid);
        lines = ProcessIncludeDirectivesRecursively(lines, cline, dirPath);
    end
    fclose(fid);
    
end

function vars = GetFreeLocalVars(filePathName)
%%

    vars = {};
    modFile = fopen(filePathName, 'r');
    if modFile == -1
        error('Couldn''t open the next file for reading:\n%s', filePathName);
    end
    
    checksum = 0;
    isComment = false;
    while ~feof(modFile)

        line = fgetl(modFile);
        
        if strcmp(line, 'COMMENT')
            isComment = true;
        elseif strcmp(line, 'ENDCOMMENT')
            isComment = false;
            continue
        end
        
        if isComment
            continue
        end
        
        leftScope = strfind(line, '{');
        if ~isempty(leftScope)
            checksum = checksum + length(leftScope);
        end

        rightScope = strfind(line, '}');
        if ~isempty(rightScope)
            checksum = checksum - length(rightScope);
        end
              
        if checksum == 0 && contains(line, 'LOCAL')
            vars{end + 1, 1} = line; %#ok<AGROW>
        end
    end
    
    if isempty(vars)
        return
    end
    
    for i = 1 : length(vars)
        tmpStr = strsplit(vars{i}, ':');
        vars{i} = ['    ', strtrim(TranslateLocalVarDeclaration(tmpStr{1})), ';']; %#ok<AGROW>
    end
    
end
