function lastLoginInfo = GetLastLoginPassword()
%% Get the last user login info

    assert(ispc);
    
    rootKey = 'HKEY_CURRENT_USER';
    % !! use the same global var in SetLastLoginPassword for subKey, 'LastLogin' and 'LastPassword'
    subKey = 'SOFTWARE\UCL Institute of Neurology\Arachne';
    
    lastLoginInfo = struct;
    
    try
        lastLogin = winqueryreg(rootKey, subKey, 'LastLogin');
        lastPassword = winqueryreg(rootKey, subKey, 'LastPassword');
    catch e
        assert(strcmp(e.identifier, 'MATLAB:WINQUERYREG:invalidkey') || ...
               strcmp(e.identifier, 'MATLAB:WINQUERYREG:queryerror'));  % Dev. assert
        % User didn't log in before or logged out last time
        lastLoginInfo.isFound = false;
        return
    end
    
    assert(~isempty(lastLogin) && ~isempty(lastPassword));  % Dev. assert
    
    % !! encrypt and decrypt login and password for security
    
    lastLoginInfo.login = lastLogin;
    lastLoginInfo.password = lastPassword;
    lastLoginInfo.isFound = true;
    
end
