function BuildWorker()
%% Build the worker

    global remoteHPC debugMode fakeMPI
    global importMod_e importMod_i
    
    if ispc
        command = ScriptCallCommand('build_worker');
        if ~remoteHPC
            % Add two arguments to the command
            command = sprintf('%s %i %i', command, debugMode, fakeMPI);
        end
        status = system(command);
        msg = 'Failed to build HPC kernel.';
        if importMod_e || importMod_i
            msg = sprintf('%s\nPlease make sure that the imported MOD-files are correct.', msg);
        end
        assert(status == 0, msg);
    elseif isunix
        error('Not implemented');
    else
        error('Not supported OS');
    end
    
end