function MaxModelSize(i2eRatio)
%% Count maximum size of the model.
%  The next global variables are assigned: num_*, delta_**, max_delay_*
    
    global memPerNodeLimit num_e num_i
    
    h0 = 1000;
    eps = 1;
    
    num_e = 0;
    reqMemPerNode = 0;
    while reqMemPerNode < memPerNodeLimit
        x1 = num_e;
        num_e = num_e + h0;
        num_i = i2eRatio * num_e; %#ok<NASGU>
        ComputeStdDevsAndPvhParams(true);
        reqMemPerNode = CountTotalMemReq();
        x2 = num_e;
    end
    
    while x2 - x1 > eps
        num_e = (x1 + x2) / 2;
        num_i = i2eRatio * num_e; %#ok<NASGU>
        ComputeStdDevsAndPvhParams(true);
        reqMemPerNode = CountTotalMemReq();
        func = reqMemPerNode - memPerNodeLimit;
        if func > 0
            x2 = num_e;
        else
            x1 = num_e;
        end
    end
    
    num_e = floor(x1);
    num_i = floor(i2eRatio * x1);
    AlignNumNeurons(false);
    ComputeStdDevsAndPvhParams(true);
    
end
