function AlignNumNeurons(alignReleaseProb)
%% Given types of synaptic conductance matrices,
%  check if alignment for the number of neurons (num_e or num_i) is required.
%  If so, do the alignment.

    % Model parameters
    global num_e num_i
    global releaseProb_ei releaseProb_ie
    
    % HPC parameters
    global ScmTypes scmType_ee scmType_ei scmType_ie scmType_ii
    
    % Compute block size for num_i
    if scmType_ie == ScmTypes.KrnOneBit || scmType_ii == ScmTypes.KrnOneBit
        blockSize_i = 64;
    else
        blockSize_i = 1;
    end
    
    % Compute block size for num_e
    if scmType_ee == ScmTypes.KrnOneBit || scmType_ei == ScmTypes.KrnOneBit
        blockSize_e = 64;
    else
        blockSize_e = 1;
    end

    % Do the alignment
    num_i_aligned = num_i;
    num_e_aligned = num_e;
    if blockSize_e ~= 1 || blockSize_i ~= 1
        if rem(num_i, blockSize_i) ~= 0
            num_i_aligned = floor(double(num_i) / blockSize_i) * blockSize_i;
        end
        if rem(num_e, blockSize_e) ~= 0
            num_e_aligned = floor(double(num_e) / blockSize_e) * blockSize_e;
        end
        
        if num_i_aligned ~= num_i || num_e_aligned ~= num_e
            pattern = [...
                'The scmTypes specified require num_e to be evenly divisible by %i and num_i to be evenly divisible by %i.\n', ...
                'The numbers of neurons were aligned to fit the requirements as follows:\n', ...
                'num_e = %i (was: %i)\n', ...
                'num_i = %i (was: %i)\n\n'];
            fprintf(pattern, blockSize_e, blockSize_i, num_e_aligned, num_e, num_i_aligned, num_i);
            if alignReleaseProb
                releaseProb_ei(num_e_aligned + 1 : num_e) = [];
                releaseProb_ie(num_i_aligned + 1 : num_i) = [];
            end
            num_e = num_e_aligned;
            num_i = num_i_aligned;
        end
   
        if num_i_aligned == 0 || num_e_aligned == 0
            error('Cannot do simulation with zero number of neurons of a type.');
        end
    end
    
end
