function ValidateAndPreprocessParamsCore()
%% Check if input parameters are not conflicting

    % Model parameters
    global g_hat_ee g_hat_ei g_hat_ie g_hat_ii
    global w_ee_max w_ii_max w_ei_max w_ie_max
    
    % HPC parameters
    global scmType_ee scmType_ei scmType_ie scmType_ii
    
    CheckScmParams('ee', g_hat_ee, w_ee_max, scmType_ee);
    CheckScmParams('ei', g_hat_ei, w_ei_max, scmType_ei);
    CheckScmParams('ie', g_hat_ie, w_ie_max, scmType_ie);
    CheckScmParams('ii', g_hat_ii, w_ii_max, scmType_ii);
    
end


function CheckScmParams(suf, g_hat, w_max, scmType)
%% Check Synaptic Conductance Matrix parameters

    global useGUI ScmTypes enableSTDP SclModels sclModel gatherSCM
    
    assert(HasField(ScmTypes, scmType));    % Dev. assert
    
    assert(~(sclModel == SclModels.BSD && scmType == ScmTypes.AllZeros && g_hat ~= 0), ...
        'Inconsistent parameter combination detected:\nscmType_%s == ScmTypes.AllZeros && g_hat_%s ~= 0.', ...
        suf, suf);
    
    assert(~(scmType == ScmTypes.AllZeros && w_max ~= 0), ...
        'Inconsistent parameter combination detected:\nscmType_%s == ScmTypes.AllZeros && w_max_%s ~= 0.', ...
        suf, suf);
    
    hint = sprintf('Please specify scmType_%s == ScmTypes.AllZeros for higher performance and lower memory usage.', ...
        suf);
    
    assert(~(scmType ~= ScmTypes.AllZeros && w_max == 0), ...
        ['Suboptimal parameter combination detected:\nscmType_%s ~= ScmTypes.AllZeros && w_max_%s == 0.\n', hint], ...
        suf, suf);
    
    assert(~(sclModel == SclModels.BSD && scmType ~= ScmTypes.AllZeros && g_hat == 0), ...
        ['Suboptimal parameter combination detected:\nscmType_%s ~= ScmTypes.AllZeros && g_hat_%s == 0.\n', hint], ...
        suf, suf);
    
    if ~useGUI
        assert(~(~enableSTDP && gatherSCM), ...
            'Option gatherSCM == true is valid only for enableSTDP == true.')
    elseif ~enableSTDP
        gatherSCM = false;
    end
    
    assert(~(enableSTDP && scmType ~= ScmTypes.HstDense && scmType ~= ScmTypes.KrnDense), ...
        'Hebbian correction is not supported for scmType == ScmTypes.%s.', ...
        GetFieldName(ScmTypes, scmType));
    
    assert(~(sclModel == SclModels.BSS && (scmType == ScmTypes.HstSparse || scmType == ScmTypes.KrnSparse || scmType == ScmTypes.KrnOneBit)), ...
        'Bell-shaped strength of connections is not supported for scmType == ScmTypes.%s.', ...
        GetFieldName(ScmTypes, scmType));
    
end
