@echo off

rem Zip the autogenerated files with C++ code and MD5-code for MOD curents.
rem Upload the archive to the cluster, then delete its local copy.
rem Call the helper remote script that will do the following:
rem 1) clean up the worker source code subdirectory with the old translated MOD currents and the old MD5-file,
rem 2) unzip the new files from the archive and delete the archive.

rem Run this BAT-script with one argument specifying:
rem 1) the name of the local directory with the autogenerated files.

rem Initialize variables
call Core\scripts\win-lin\params.bat

rem Set the temporary directory path and the archive name
set AUTOGENFILESDIR=%HOSTTEMPDIR%\%1
set ARCHIVENAME=_AutogenFiles

rem Go to the temporary directory
cd /d "%AUTOGENFILESDIR%"

rem Create ZIP archive
echo Zipping C++/MD5 files ...
%THIRDPARTYDIR%\7za.exe a %ARCHIVENAME%.zip -r * > NUL

rem Go to 3rd party software directory containing pscp.exe and plink.exe
cd /d %THIRDPARTYDIR%

rem Upload ZIP-file to the head node of HPC cluster
pscp -pw %PASSWORD% "%AUTOGENFILESDIR%\%ARCHIVENAME%.zip" %LOGIN%@%HEADNODEIP%:"%HEADNODEWORKERDIR%/ModCurrents"
echo.

rem Delete the local archive
del "%AUTOGENFILESDIR%\%ARCHIVENAME%.zip"

rem Call the helper remote script
plink -pw %PASSWORD% %LOGIN%@%HEADNODEIP% cd \"%HEADNODEWORKERDIR%/scripts\"; sh embed_mod_currents.sh %ARCHIVENAME%
