function ExposeDashboardFigure()
%% !!
% TODO: Think about usage of the next functionality supported by Widgets Toolbox:
% 1. Selecting several nodes at the same time (with CTRL pressed):
%    https://www.mathworks.com/matlabcentral/mlc-downloads/downloads/submissions/66235/versions/3/previews/demo/html/demoTree.html#4
% 2. Renaming projects, simulations, input files directly in the tree,
%    however, this functionality does not work in the current Widgets Toolbox version (updated 8 Mar 2018):
%    https://www.mathworks.com/matlabcentral/mlc-downloads/downloads/submissions/66235/versions/3/previews/demo/html/demoTree.html#9
% 3. Moving nodes within the tree (drag and drop):
%    https://www.mathworks.com/matlabcentral/mlc-downloads/downloads/submissions/66235/versions/3/previews/demo/html/demoTree.html#12

    close all % !!
    
    f = figure(...
        'Name', 'Dashboard', ...
        'Toolbar', 'none', ...
        'NumberTitle', 'off', ...
        'Units', 'pixels', ...
        'Position', [100 100 620 430]);
    movegui(f, [100 -100])

    w = uiw.widget.Tree(...
        'Parent', f, ...
        'SelectionChangeFcn', @(h,e)disp(e), ...
        'Units', 'pixels', ...
        'Position', [10 30 300 390]);

    details = uicontrol(...
        'Parent', f, ...
        'Style', 'edit', ...
        'Max', 2, ...
        'HorizontalAlignment', 'left', ...
        'Enable', 'off', ...
        'Position', [320 31 290 388]);

    label = uicontrol(...
        'Parent', f, ...
        'Style', 'text', ...
        'String', 'Connection status: OK', ...
        'HorizontalAlignment', 'right', ...
        'Position', [320 2 290 20]);

    [success, data] = SerReqDashboardGet();
    if ~success
        return
    end
    
    SimStatuses = struct('New', 1, 'Running', 2, 'Succeeded', 3, 'Failed', 4);

    simContextMenus = {...
        {'Start', 'Share', 'Create copy', 'Delete'}, ...      % New
        {'Get snapshot', 'Ask to terminate', 'Kill'}, ...     % Running
        {'Continue', 'Share', 'Create copy', 'Delete'}, ...   % Succeeded
        {'Recover', 'Share', 'Create copy', 'Delete'}};       % Failed

    % Load icons (move it to bootstrap!!)
    userIcon = PrepareIconFileAbsPath('user');
    projIcon = PrepareIconFileAbsPath('project');
    simNew = PrepareIconFileAbsPath('simNew');
    simRunningIcon = PrepareIconFileAbsPath('simRunning');
    simSucceededIcon = PrepareIconFileAbsPath('simSucceeded');
    simFailedIcon = PrepareIconFileAbsPath('simFailed');
    simIcons = {simNew, simRunningIcon, simSucceededIcon, simFailedIcon};
    logIcon = PrepareIconFileAbsPath('log');
    ipIcon = PrepareIconFileAbsPath('inputParams');
    ifeIcon = PrepareIconFileAbsPath('inputFilesEmpty');
    ifneIcon = PrepareIconFileAbsPath('inputFilesNonEmpty');
    ifsIcons = {ifeIcon, ifneIcon};
    resIcon = PrepareIconFileAbsPath('results');

    userNode = w.Root;
    userId = GetFieldName(data, 1);
    userName = data.(userId);
    userNode.Name = userName;
    setIcon(userNode, userIcon);

    projects = data.projects;
    projIds = fieldnames(projects);

    for projIdx = 1 : length(projIds)
        projId = projIds{projIdx};
        proj = projects.(projId);
        projName = proj.name;
        userData = struct(projId, proj);
        projNode = uiw.widget.TreeNode('Name', projName, 'Parent', userNode, 'UserData', userData);
        setIcon(projNode, projIcon);

        if ~isfield(proj, 'simulations')
            continue
        end

        simulations = proj.simulations;
        simIds = fieldnames(simulations);

        for simIdx = 1 : length(simIds)
            simId = simIds{simIdx};
            sim = simulations.(simId);
            simName = sim.name;
            userData = struct(simId, sim);
            simNode = uiw.widget.TreeNode('Name', simName, 'Parent', projNode, 'UserData', userData);
            simStatus = sim.status;
            simIcon = simIcons{simStatus};
            setIcon(simNode, simIcon);

            paramsNode = uiw.widget.TreeNode('Name', 'Input Params', 'Parent', simNode);
            setIcon(paramsNode, ipIcon);

            ifsNode = uiw.widget.TreeNode('Name', 'Input Files', 'Parent', simNode);
            hasInputFiles = isfield(sim, 'inputFiles');
            ifsIcon = ifsIcons{1 + hasInputFiles};
            setIcon(ifsNode, ifsIcon);

            if hasInputFiles
                inputFiles = sim.inputFiles;
                for ifIdx = 1 : length(inputFiles)
                    ifName = inputFiles{ifIdx};
                    ifNode = uiw.widget.TreeNode('Name', ifName, 'Parent', ifsNode);
                    setIcon(ifNode, logIcon); % !!
                end
            end

            switch simStatus
                case SimStatuses.New
                    % !!
                case SimStatuses.Running
                    CreateInfoLogNode(simNode);
                case SimStatuses.Succeeded
                    resNode = uiw.widget.TreeNode('Name', 'Results', 'Parent', simNode);
                    setIcon(resNode, resIcon);
                    CreateInfoLogNode(simNode);
                case SimStatuses.Failed
                    errLogNode = uiw.widget.TreeNode('Name', 'Error Log', 'Parent', simNode);
                    setIcon(errLogNode, logIcon);
                otherwise
                    assert(false);  % Dev. assert
            end

            simContextMenu = uicontextmenu('Parent', f);
            simContextMenuItems = simContextMenus{simStatus};
            for itemIdx = 1 : length(simContextMenuItems)
                uimenu(simContextMenu, 'Label', simContextMenuItems{itemIdx}, 'MenuSelectedFcn', @MenuSelectedFcn);
            end
            set(simNode, 'UIContextMenu', simContextMenu)
            % !! add icons to menu items
                
        end
    end

    % Set the selection change callback function for all nodes
    w.SelectionChangeFcn = @SelectionChangeFcn;

    % Add context menu for the whole tree
    treeContextMenu = uicontextmenu('Parent', f);
    uimenu(treeContextMenu, 'Label', 'Refresh', 'MenuSelectedFcn', @MenuSelectedFcn);
    set(w, 'UIContextMenu', treeContextMenu)

    
    % !!
    function CreateInfoLogNode(simNode)
        logNode = uiw.widget.TreeNode('Name', 'Info Log', 'Parent', simNode);
        setIcon(logNode, logIcon);
    end


    projDetailsPat = ['%s Details\n', ...
                      '\n', ...
                      'Description: %s\n', ...
                      'Shared with: Nobody'];
    
    simDetailsPat = ['%s Details\n', ...
                     '\n', ...
                     'Description: %s\n', ...
                     'Status: %s\n', ...
                     'Started on: 7/20/2018 12:18 AM\n', ...
                     'Worker version: 2.3\n', ...
                     'Continuable: Yes\n', ...
                     'Recoverable: Yes\n', ...
                     '#Complete sessions: 3\n', ...
                     '#Nodes: 10\n', ...
                     '#Cores per Node: 4\n', ...
                     'Shared by: Nobody\n', ...
                     'Shared with: Nobody'];

    function SelectionChangeFcn(h, e)
        if isempty(h.SelectedNodes)
            details.String = '';
            return
        end
        disp(h.SelectedNodes.Name);  % !!
        userData = h.SelectedNodes.UserData;
        if isempty(userData)
            details.String = '';
            return
        end
        assert(isstruct(userData));	% Dev. assert
        fn = fieldnames(userData);
        assert(length(fn) == 1);	% Dev. assert
        objId = fn{1};
        obj = userData.(objId);
        if startsWith(objId, 'proj')
            details.String = sprintf(projDetailsPat, obj.name, obj.description);
        elseif startsWith(objId, 'sim')
            simStatus = GetFieldName(SimStatuses, obj.status);
            details.String = sprintf(simDetailsPat, obj.name, obj.description, simStatus);
        end
    end

    function MenuSelectedFcn(menu, actionData)
        disp(menu.Text);  % !!
    end

end