function AddInitCondBCurParams()
%% Initial conditions for the basic currents ODEs

    AddPanel('Init. Cond. (B-Cur)');
    
    relPred = 'basicCurrentFactor_e ~= 0';
    AddRatVector('n_e', 'zeros(num_e, 1)', '', 'Potassium channel activation for e-neurons', relPred, PrepareValPred('n_e'));
    AddRatVector('h_e', 'zeros(num_e, 1)', '', 'Sodium channel inactivation for e-neurons', relPred, PrepareValPred('h_e'));

    relPred = 'basicCurrentFactor_i ~= 0';
    AddRatVector('n_i', 'zeros(num_i, 1)', '', 'Potassium channel activation for i-neurons', relPred, PrepareValPred('n_i'));
    AddRatVector('h_i', 'zeros(num_i, 1)', '', 'Sodium channel inactivation for i-neurons', relPred, PrepareValPred('h_i'));
    
end

function valPred = PrepareValPred(parName)
%%
    valPredPat = 'length(%s) == num_%s && all(%s >= 0) && all(%s <= 1)';
    valPred = sprintf(valPredPat, parName, parName(end), parName, parName);
end