function AddMeasuredParams()

    AddPanel('Measured');
    
    AddPosRatVector('opRadii', '[1234]', 'm', 'Radii of the observation points in polar coordinate system', true, 'length(opRadii) == length(opAngles)');
    AddRatVector('opAngles', '[2.5]', 'rad', 'Angles of the observation points in polar coordinate system', true, 'length(opRadii) == length(opAngles)');
    AddRatScalar('electrolCond', 100, 'S', 'The electolytic conductance', '~isempty(opRadii) && ~isempty(opAngles)');
    
    desc = {'Stabilization analysis mode', ...
            '<b>unchecked:</b> <i>compute Frequency_e, Frequency_i, syncoef_e, syncoef_i just once at the end of the simulation;</i>', ...
            '<b>checked:</b> <i>compute Frequency_e, Frequency_i, syncoef_e, syncoef_i on each iteration</i>', ...
            '(this affects performance).'};
    AddBoolScalar('stabAnalysis', true, desc);
    AddBoolScalar('gatherSCM', true, 'Show matrices of synaptic conductance at end of simulation');
    AddBoolScalar('watchGTonicGABA', true, 'Whether to collect data to plot GTonicGABA vs time', 'dynamicGTonicGABA');
    
    descPat = 'Array of indexes of %s-cells to watch presynaptic voltage of<br>(the curves of voltage vs time will be shown)';
    AddPosIntVector('watchedCellIdx_e', '[1]', sprintf(descPat, 'e'));
    AddPosIntVector('watchedCellIdx_i', '[1]', sprintf(descPat, 'i'));
    
    descPat1 = 'Whether to apply voltage clamp to one %s-cell and watch its current';
    descPat2 = 'Voltage clamp applied to the %s-cell indicated by %%clampedWatchedCellIdx_%s';
    descPat3 = 'Index of %s-cell to clamp voltage at %%voltageClamp_%s and watch current<br>(the curve of current vs time will be shown)';
    
    AddBoolScalar('clampWatchOneCell_e', false, sprintf(descPat1, 'e'));
    relPred = 'clampWatchOneCell_e';
    AddPosIntScalar('clampedWatchedCellIdx_e', '1', sprintf(descPat3, 'e', 'e'), relPred, 'clampedWatchedCellIdx_e <= num_e');
    AddRatScalar('voltageClamp_e', '-65', 'mV', sprintf(descPat2, 'e', 'e'), relPred);
    
    AddBoolScalar('clampWatchOneCell_i', false, sprintf(descPat1, 'i'));
    relPred = 'clampWatchOneCell_i';
    AddPosIntScalar('clampedWatchedCellIdx_i', '1', sprintf(descPat3, 'i', 'i'), relPred, 'clampedWatchedCellIdx_i <= num_i');
    AddRatScalar('voltageClamp_i', '-56', 'mV', sprintf(descPat2, 'i', 'i'), relPred);
    
    AddPosIntMatrix('watchedSynIdx_ee', 'zeros(0, 2)', 'Array of indexes of ee-synapses to watch synaptic conductance for');
    AddPosIntMatrix('watchedSynIdx_ei', '[1, 1]', 'Array of indexes of ei-synapses to watch synaptic conductance for');
    AddPosIntMatrix('watchedSynIdx_ie', 'zeros(0, 2)', 'Array of indexes of ie-synapses to watch synaptic conductance for');
    AddPosIntMatrix('watchedSynIdx_ii', 'zeros(0, 2)', 'Array of indexes of ii-synapses to watch synaptic conductance for');

    AddRatScalar('frequencyParam', 2000, 'Hz', 'Network frequency');
    AddRatScalar('syncoefParam', 500, '', 'Network synchronization');
    
end