function AddModelBCurParams()

    AddPanel('Model (B-Cur)');
    
    AddRatScalar('basicCurrentFactor_e', 1, '', 'Basic current factor for e-neurons. Assign 0 to remove the current.', true, 'basicCurrentFactor_e >= 0 && basicCurrentFactor_e <= 1');
    AddRatScalar('basicCurrentFactor_i', 1, '', 'Basic current factor for i-neurons. Assign 0 to remove the current.', true, 'basicCurrentFactor_i >= 0 && basicCurrentFactor_i <= 1');

    desc_e = 'Kinetic parameter of the basic current in e-neurons';
    desc_i = 'Kinetic parameter of the basic current in i-neurons';
    
    relPred_e = 'basicCurrentFactor_e ~= 0';
    relPred_i = 'basicCurrentFactor_i ~= 0';
    
    AddRatScalar('h_e_v_1', 50, '', desc_e, relPred_e);
    AddRatScalar('m_e_v_1', 54, '', desc_e, relPred_e);
    AddRatScalar('n_e_v_1', 52, '', desc_e, relPred_e);
    AddRatScalar('h_i_v_1', 58, '', desc_i, relPred_i);
    AddRatScalar('m_i_v_1', 35, '', desc_i, relPred_i);
    AddRatScalar('n_i_v_1', 34, '', desc_i, relPred_i);
    
    AddRatScalar('h_e_v_2', 27, '', desc_e, relPred_e);
    AddRatScalar('m_e_v_2', 27, '', desc_e, relPred_e);
    AddRatScalar('n_e_v_2', 57, '', desc_e, relPred_e);
    AddRatScalar('h_i_v_2', 28, '', desc_i, relPred_i);
    AddRatScalar('m_i_v_2', 60, '', desc_i, relPred_i);
    AddRatScalar('n_i_v_2', 44, '', desc_i, relPred_i);
    
    AddRatScalar('h_e_a_1', 0.128, '', desc_e, relPred_e);
    AddRatScalar('m_e_a_1', 0.32,  '', desc_e, relPred_e);
    AddRatScalar('n_e_a_1', 0.032, '', desc_e, relPred_e);
    AddRatScalar('h_i_a_1', 0.07,  '', desc_i, relPred_i);
    AddRatScalar('m_i_a_1', 0.1,   '', desc_i, relPred_i);
    AddRatScalar('n_i_a_1', -0.01, '', desc_i, relPred_i);
    
    AddRatScalar('h_e_a_2', 18,   '', desc_e, relPred_e);
    AddRatScalar('m_e_a_2', 4,    '', desc_e, relPred_e);
    AddRatScalar('n_e_a_2', 5,    '', desc_e, relPred_e);
    AddRatScalar('h_i_a_2', 20,   '', desc_i, relPred_i);
    AddRatScalar('m_i_a_2', 10,   '', desc_i, relPred_i);
    AddRatScalar('n_i_a_2', -0.1, '', desc_i, relPred_i);
    
    AddRatScalar('h_e_b_1', 4,     '', desc_e, relPred_e);
    AddRatScalar('m_e_b_1', 0.28,  '', desc_e, relPred_e);
    AddRatScalar('n_e_b_1', 0.5,   '', desc_e, relPred_e);
    AddRatScalar('h_i_b_1', 1,     '', desc_i, relPred_i);
    AddRatScalar('m_i_b_1', 4,     '', desc_i, relPred_i);
    AddRatScalar('n_i_b_1', 0.125, '', desc_i, relPred_i);
    
    AddRatScalar('h_e_b_2', 5,    '', desc_e, relPred_e);
    AddRatScalar('m_e_b_2', 5,    '', desc_e, relPred_e);
    AddRatScalar('n_e_b_2', 40,   '', desc_e, relPred_e);
    AddRatScalar('h_i_b_2', -0.1, '', desc_i, relPred_i);
    AddRatScalar('m_i_b_2', 18,   '', desc_i, relPred_i);
    AddRatScalar('n_i_b_2', 80,   '', desc_i, relPred_i);
    
    AddRatScalar('phi', 5, '', desc_i, relPred_i);
    
    AddRatScalar('c1_e', 80,   'mS / cm2', 'Potassium conductance in Pyramidal cell',       relPred_e);
    AddRatScalar('c2_e', -100, 'mV',       'Reverse Potassium potential in Pyramidal cell', relPred_e);
    AddRatScalar('c3_e', 100,  'mS / cm2', 'Sodium conductance in Pyramidal cell',          relPred_e);
    AddRatScalar('c4_e', 50,   'mV',       'Reverse Na potential in Pyramidal cell',        relPred_e);
    AddRatScalar('c1_i', 9,    'mS / cm2', 'Potassium conductance in interneurons',         relPred_i);
    AddRatScalar('c2_i', -90,  'mV',       'Reverse Potassium potential in interneurons',   relPred_i);
    AddRatScalar('c3_i', 35,   'mS / cm2', 'Sodium conductance in interneuron',             relPred_i);
    AddRatScalar('c4_i', 55,   'mV',       'Reverse potential of Sodium in interneuron',    relPred_i);
    
end