function [hc, xPos] = CreateParamEditBox(value, xPos, desc)

    global panIdx params layout palette
    
    xPos = xPos + layout.xMargin2;
    parIdx = length(params{panIdx}) + 1;
    
    % Prepare tooltip
    desc = DescToHtmlString(desc);
    
    hc = uicontrol('Style', 'edit', ...
                   'Units', 'pixels', ...
                   'Position', [xPos, 0, layout.ebWidth, layout.ebHeight], ...
                   'String', num2str(value), ...
                   'UserData', [panIdx, parIdx], ...
                   'BackgroundColor', palette.validColor, ...
                   'Callback', @generic_Callback, ...
                   'TooltipString', desc);
    xPos = xPos + layout.ebWidth;
    
end