function pb_OK_Callback(~, ~)
%% The function called once user clicks "OK" button

    global invalidParams hf saveInput2Output
    global guiType useGUI
    global GuiTypes
    
    % Make sure that all the parameters are valid
    msg = ['The following parameters are not valid:', invalidParams];
    if iscell(msg)
        % The assert function does not accept a cell array
        msg = strjoin(msg, '\n');
    end
    foo = @()assert(isempty(invalidParams), msg);
    success = CallWithErrorHandlingPolicy(foo, 'Invalid parameters (basic validation)');
    if ~success
        % Give user a chance to correct the input parameters in GUI (i.e. do not abort the program)
        return
    end
    
    % Re-initialize global variables containing parameters values.
    % (We need this just in case if there was an error between the "CastParams" call and the figure closing below,
    % and user clicked "OK" one more time without any changes in GUI.
    % In this case, "EvaluateAllRemainders" would fail, because it expects non-casted parameters.)
    UpdateViewControls();
    
    % Evaluate all remainders given GUI type
    foo = @()EvaluateAllRemainders(guiType);
    success = CallWithErrorHandlingPolicy(foo, 'Invalid parameters (deep validation)');
    if ~success
        % Give user a chance to correct the input parameters in GUI (i.e. do not abort the program)
        return
    end
    
    [closeBefore, okHandler, returnAfter] = GuiTypeToOkHandler(guiType);
    
    % Hide GUI while a lot of info is printed to console.
    % (We will close the figure as late as possible so maximum number of fixable errors could occur before it is closed.)
    if useGUI && closeBefore
        set(hf, 'Visible', 'off');
    end
    
    if guiType == GuiTypes.StartFromScratch
        % Prepare the executable "gs.exe" before starting simulation from scratch
        % Remark: We assume that HPC kernel C++ code itself is fine so errors can be in MOD-files only
        foo = @PrepareForStartFromScratch;
        success = CallWithErrorHandlingPolicy(foo, 'Invalid MOD-files (translation/compilation)');
        if ~success
            % Give user a chance to correct MOD-files (i.e. do not abort the program)
            if useGUI
                set(hf, 'Visible', 'on');
            end
            return
        end
    end
    
    % Cast parameters to proper types: single, int32 or logical
    if guiType == GuiTypes.StartFromScratch
        CastParams();
    end
    
    % Save input parameters
    if saveInput2Output
        SaveParams(PrepareIOFileAbsPath('guiParams.mat'));
    end
    
    if closeBefore
        % Close the figure
        % TODO: Close it before CastParams (currently we cannot do so, because GetUIControlStyle gets info from controls)
        close(hf);
    end
    
    % Execute the custom part of "OK" button handler
    CallWithErrorHandlingPolicy(okHandler, 'Runtime error', true);
    
    if returnAfter
        return
    end
    
    % Grab output MAT-file from remote cluster or HPC kernel directory
    getFromSnapshot = false;
    % !! follow error policy here
    GrabReadAndVisualizeResults(getFromSnapshot);

end


function PrepareForStartFromScratch()
%% Prepare the executable "gs.exe" before starting simulation from scratch

    global debugMode
    
    % Check the HPC kernel state
    [exePresent, md5Equal, newMd5FileName] = CheckWorkerAppState();

    if ~md5Equal || debugMode
        % Translate all the MOD files to C++ source and header files for both "e" and "i" neurons,
        % create an empty MD5-file,
        % then deploy the files to the worker source code directory
        TranslateModFilesAndDeployAutogenFiles(newMd5FileName);
    else
        disp('Don''t need to retranslate the MOD files.');
    end

    if ~exePresent || ~md5Equal || debugMode
        % Build the worker
        BuildWorker();
    else
        disp('Don''t need to rebuild the worker.');
    end
    
end
