function [closeBefore, okHandler, returnAfter] = GuiTypeToOkHandler(guiType)

    global pushbutton_OK_Delegate GuiTypes mobileMode
    
    switch guiType
        case {GuiTypes.StartFromScratch, GuiTypes.ContinueOldSession}
            closeBefore = true;
            okHandler = @RunAndMonitor;
            returnAfter = mobileMode;
        case GuiTypes.MonitorBackgroundProcess
            closeBefore = true;
            okHandler = @MonitorBackgroundProcess;
            returnAfter = mobileMode;
        case GuiTypes.TakeOutputData
            closeBefore = true;
            okHandler = @()GrabReadAndVisualizeResults(false);
            returnAfter = true;
        case {GuiTypes.ScriptTakeSnapshot, GuiTypes.UtilityPlotStdpModels, GuiTypes.UtilityComputeMaxModelSize}
            % !! why ScriptTakeSnapshot closes the window in installed mode?
            closeBefore = mobileMode;
            okHandler = pushbutton_OK_Delegate;
            returnAfter = true;
        otherwise
            error('Unknown GUI type');  % Dev. error
    end
    
end