function SaveParams(filePathName)
%% Add all parameters to current workspace and save all necessary input data to file
    
    global params
    
    output = {};
    
    % Loop by panels
    for panIdx_ = 1 : length(params)
        
        % Loop by all parameters of this panel
        for parIdx = 1 : length(params{panIdx_})
            
            varName = params{panIdx_}{parIdx}.name;
            handlers = params{panIdx_}{parIdx}.handlers;
            
            h2 = handlers(2);
            [value, style, ~] = GetUIControlValue(h2); %#ok<ASGLU>
            
            if strcmp(style, 'pushbutton')
                continue
            end
            
            cmd = sprintf('%s = value;', varName);
            eval(cmd);
    
            output = [output; varName];
        end
    end
    
    save(filePathName, output{:});

end
