function EvaluateAllRemainders(guiType)
%% Evaluate all remainders given GUI type:
%  check if input parameters are not conflicting,
%  do preprocessing of the parameters.

    global outFileName remoteHPC hostParams loadedNodes GuiTypes

    switch guiType
        case GuiTypes.StartFromScratch
            RelParamsDispatcher();
            HpcParamsRemainder();
            ModelParamsRemainder();
            MeasuredParamsRemainder();
            RngParamsRemainder();
            ValidateAndPreprocessParams();
            ParamsPostprocessing();
            CheckMemReq();
        case GuiTypes.ContinueOldSession
            if remoteHPC
                hostParams = strjoin(loadedNodes, ',');
            end
        case {GuiTypes.MonitorBackgroundProcess, GuiTypes.TakeOutputData, GuiTypes.ScriptTakeSnapshot, GuiTypes.UtilityPlotStdpModels}
            % (empty)
        case {GuiTypes.UtilityComputeMaxModelSize}
            RelParamsDispatcherCore();
            HpcParamsRemainderCore();
            ModelParamsRemainderCore();
            ValidateAndPreprocessParamsCore();
        otherwise
            error('Unknown GUI type');  % Dev. error
    end
    
    switch guiType
        case {GuiTypes.ContinueOldSession, GuiTypes.MonitorBackgroundProcess, GuiTypes.TakeOutputData, GuiTypes.ScriptTakeSnapshot}
            if ~endsWith(outFileName, '.mat', 'IgnoreCase', true)
                outFileName = [outFileName, '.mat'];
            end
    end
end

function RelParamsDispatcher()
%%

    global scalTest np nt maxNP maxNT
    global hostParams loadedNodes
    
    RelParamsDispatcherCore();
    
    if scalTest
        np = maxNP;
        nt = maxNT;
    end
    
    hostParams = strjoin(loadedNodes, ',');
    
end

function ParamsPostprocessing()
%%

    global scmSeeds uSeeds releaseSeeds
    
    scmSeeds = scmSeeds';
    uSeeds = uSeeds';
    releaseSeeds = releaseSeeds';
    
end
