function HpcParamsRemainder()

    global fakeMPI remoteHPC backgroundMode scalTest
    global useSPA distMatPVH class
    global hostParams
    global loadedNodes
    
    if fakeMPI
        distMatPVH = false;
    end
    
    HpcParamsRemainderCore();
    
    if useSPA
        class = 'single';
    else
        class = 'double';
    end
    
    if remoteHPC
        % List of nodes that will be passed to the script
        hostParams = strjoin(loadedNodes, ',');
    end
    
    % Arachne can be run in foreground remotely, but we disallow this mode by two reasons:
    % 1) The process is not killed automatically when connection is dropped between host and kernel.
    %    As a result, several foreground simulations can be launched in parallel causing file collisions in I/O directories.
    % 2) Host cannot monitor foreground simulation correctly after dropping of connection --
    %    it's considered as background simulation that does not respond.
    if scalTest
        backgroundMode = false;
    elseif remoteHPC
        backgroundMode = true;
    end
    
end