function MeasuredParamsRemainder()
%%

    global opRadii opAngles opNum
    global clampWatchOneCell_e v_e clampedWatchedCellIdx_e voltageClamp_e
    global clampWatchOneCell_i v_i clampedWatchedCellIdx_i voltageClamp_i
    
    opNum = length(opRadii);
    
    % Validate opRadii and opAngles
    ValidateObservationPoints();
    
    % Transpose vectors
    opRadii = opRadii';
    opAngles = opAngles';
    
    % Correct the initial conditions for presynaptic voltages if some cells are clamped
    if clampWatchOneCell_e
        v_e(clampedWatchedCellIdx_e) = voltageClamp_e;
    end
    if clampWatchOneCell_i
        v_i(clampedWatchedCellIdx_i) = voltageClamp_i;
    end
    
end

function ValidateObservationPoints()
%% Validate opRadii and opAngles

    global opRadii opAngles opNum
    global num_e num_i radius_e radius_i useSPA
    
    ulp = 100;
    if useSPA
        precision_e = ulp * eps(single(radius_e));
        precision_i = ulp * eps(single(radius_i));
    else
        precision_e = ulp * eps(radius_e);
        precision_i = ulp * eps(radius_i);
    end
    
    msgPattern = 'The observation point with radius %d and angle %d is too close to one of %s-neurons.';
    
    for i = 1 : opNum
        opRadius = opRadii(i);
        opAngle = opAngles(i);
        
        % Check e-network
        p1 = radius_e ^ 2 + opRadius ^ 2;
        p2 = 2 * radius_e * opRadius;
        for j = 1 : num_e
            assert(p1 - p2 * cos(opAngle - 2 * pi * (j - 1) / num_e) > precision_e, sprintf(msgPattern, opRadius, opAngle, 'e'));
        end
        
        % Check i-network
        p1 = radius_i ^ 2 + opRadius ^ 2;
        p2 = 2 * radius_i * opRadius;
        for j = 1 : num_i
            assert(p1 - p2 * cos(opAngle - 2 * pi * (j - 1) / num_i) > precision_i, sprintf(msgPattern, opRadius, opAngle, 'i'));
        end
    end
    
end