function ModelParamsRemainder()
%%

    global dt
    global dynamicGTonicGABA
    global enableFreqDelay freqDelay
    global delta_ee delta_ii delta_ei delta_ie max_delay_e max_delay_i
    global enableSTDP
    global imageMode
    global importSTDP
    global stdpFile_ee stdpFile_ii stdpFile_ie stdpFile_ei stdp_factor factorNum
    global size_factor t_start_factor t_end_factor
    global stdpMatrix_ee stdpMatrix_ei stdpMatrix_ii stdpMatrix_ie
    
    ModelParamsRemainderCore();

    % Compute the standard deviations and parameters of presynaptic voltage history matrices
    ComputeStdDevsAndPvhParams(false);
    
    if ~enableSTDP
        imageMode = false;
    end

    if dynamicGTonicGABA && enableFreqDelay
        freqDelay_iter = round(freqDelay / dt);
        freqDelay = freqDelay_iter;
    end
    
    if importSTDP
        [stdpMatrix_ee, factor_ee, size_factor_ee, t_start_factor_ee, t_end_factor_ee] = ReadFile(stdpFile_ee, 'ee');
        [stdpMatrix_ei, factor_ei, size_factor_ei, t_start_factor_ei, t_end_factor_ei] = ReadFile(stdpFile_ei, 'ei');
        [stdpMatrix_ie, factor_ie, size_factor_ie, t_start_factor_ie, t_end_factor_ie] = ReadFile(stdpFile_ie, 'ie');
        [stdpMatrix_ii, factor_ii, size_factor_ii, t_start_factor_ii, t_end_factor_ii] = ReadFile(stdpFile_ii, 'ii');
        
        stdp_factor = [factor_ee; factor_ei; factor_ii; factor_ie];
        factorNum = int32(length(stdp_factor));

        size_factor = [size_factor_ee; size_factor_ei; size_factor_ii; size_factor_ie];
        size_factor = int32(size_factor);

        t_start_factor = [t_start_factor_ee; t_start_factor_ei; t_start_factor_ii; t_start_factor_ie];
        t_end_factor = [t_end_factor_ee; t_end_factor_ei; t_end_factor_ii; t_end_factor_ie];
    end
    
    %% Cast to int32 all the scalars of integer nature
    delta_ee = int32(delta_ee);
    delta_ei = int32(delta_ei);
    delta_ie = int32(delta_ie);
    delta_ii = int32(delta_ii);
    max_delay_e = int32(max_delay_e);
    max_delay_i = int32(max_delay_i);
       
end


function [stdpMatrix, factor, numRows, t_start, t_end] = ReadFile(stdpFile, suffix)
%% Read and validate tabulated STDP model file

    stdpMatrix = ReadValidateStdpFile(stdpFile, suffix);
    
    time = stdpMatrix(:, 1);
    factor = stdpMatrix(:, 2);
    
    numRows = size(stdpMatrix, 1);
    t_start = time(1);
    t_end = time(end);
    
end
