function hb = AddButton(parent, text, handler)
%% Add a button on the parent (figure or panel)

    global elemIdx
    
    isMain = IsMainMenuFigure(parent);
    
    if isMain
        hb = uibutton('Parent', parent, ...
                      'Text', text, ...
                      'ButtonPushedFcn', handler, ...
                      'Position', GetElementPosition(elemIdx));
        
        % !!
        if strcmp(text, 'Dashboard mockup')
            hb.BackgroundColor = [0.75, 1, 0.75];
        end
    else
        hb = uicontrol('Parent', parent, ...
                       'Style', 'pushbutton', ...
                       'String', text, ...
                       'FontName', 'Halvetica', ... % !! for consistency with default appdesigner style
                       'FontSize', 9, ...           % !!
                       'Callback', handler, ...
                       'Position', GetElementPosition(elemIdx));
        
        % !! try to tweak Swing properties here to make button corners round (for consistency with the main fugure)
        % https://stackoverflow.com/questions/423950/rounded-swing-jbutton-using-java
        % https://docs.oracle.com/javase/7/docs/api/javax/swing/BorderFactory.html
        % hj = findjobj(hb);
        % hj.setBorder(javax.swing.BorderFactory.createEtchedBorder());
    end
    
    elemIdx = elemIdx - 1;
    
end
