function hef = AddEditField(parent, defaultText)
%% Add an edit field on the parent (figure or panel)
% !! Rename this func, because it actually does not create editfield

% !! test: try to close the form when the focus is on each field (sometimes I get "Invalid or deleted object." error)

    global elemIdx
    
    assert(~IsMainMenuFigure(parent));  % Dev. assert
    
    % !! move them to Palette
    jWhite = java.awt.Color(1, 1, 1);
    jGray = java.awt.Color(0.5, 0.5, 0.5);
    jBlack = java.awt.Color(0, 0, 0);
    % !! jTest = java.awt.Color(1, 0, 0); % !!
    
    % !!
    white = [1, 1, 1];
    gray = [0.5, 0.5, 0.5];
    black = [0, 0, 0];
    
    hef = uicontrol('Parent', parent, ...
                    'Style', 'edit', ...
                    'String', defaultText, ...
                    'FontName', 'Halvetica', ...    % !! for consistency with default appdesigner style
                    'FontSize', 9, ...              % !! why not 12 (as in default appdesigner style)? maybe I need to specify: 'Units', 'Pixels'
                    'ForegroundColor', gray, ...
                    'Position', GetElementPosition(elemIdx), ...
                    'UserData', true);  % !! isEmpty
    % !! undocumented
    jtf = findjobj(hef);   % !! 3rdparty. Think about just extracting a piece of code executed for editboxes
                           % !! investigate if it can be adopted for editfield
    
    % !! class(jtf) = 'javahandle_withcallbacks.com.mathworks.hg.peer.EditTextPeer$hgTextField'
    
    set(jtf, 'FocusGainedCallback', @TextFocusGainedCallback);
    set(jtf, 'FocusLostCallback', @TextFocusLostCallback);

    % !!
    % [handles,levels,parentIdx,listing] = findjobj(h);
    
    % !!
    % l = addlistener(h, 'PropertyAdded', @(app, event) FocusGainedCallback(app, event));
    
    % !! Investigate how I can hide the default text when user enters EditField and show it again when user exits it (leaving it empty):
    % See here:
    % https://undocumentedmatlab.com/blog/uicontrol-callbacks
    
    % !! maybe I have to create the old-style figure to be able to attach the enter/exit event handlers
    
    % !!
    function TextFocusGainedCallback(jTextField, eventdata)
        % disp('TextFocusGainedCallback'); % !!
        % !! class(jTextField) =  'javahandle_withcallbacks.com.mathworks.hg.peer.EditTextPeer$hgTextField'
        % !! use java functionality here, because otherwise I encounter "Invalid or deleted object." error on windows close
        % !! jTextField.setBackground(jWhite);
        % Adjust the color (it could be marged as invalid or unset)
        jTextField.setForeground(jBlack);  % !! <--- works only at 2nd time
        jTextField.setBackground(jWhite);  % !! <--- works only at 2nd time
        set(hef, 'ForegroundColor', black);
        set(hef, 'BackgroundColor', white);
        % disp('set black'); % !!
        % disp(isEmpty); % !!
        isEmpty = get(hef, 'UserData');
        if isEmpty
            % !! jTextField.setText('');
            set(hef, 'String', '');
        end
        
        % disp('exit'); % !!
    end
    
    function TextFocusLostCallback(jTextField, eventdata)
        % disp('TextFocusLostCallback'); % !!
        % !! disp(eventdata); % !!
        % !!
        % class(jTextField) = 'javahandle_withcallbacks.com.mathworks.hg.peer.EditTextPeer$hgTextField'
        % !! use java functionality here, because otherwise I encounter "Invalid or deleted object." error on windows close
        text = jTextField.getText();
        isEmpty = text.isEmpty();
        % disp(isEmpty); % !!
        if isvalid(hef) % !! check for validity is needed, because it is called on window close when hef is invalid 
            set(hef, 'UserData', isEmpty);
            if isEmpty
                % !! jTextField.setText(defaultText); % !! <--- this string causes java.lang.NullPointerException !!
                % !! jTextField.setForeground(jGray);
                set(hef, 'String', defaultText);    % !! this has not effect when user pressed tab to leave the field
                set(hef, 'ForegroundColor', gray);
                %disp('set gray'); % !!
            end
        end
        % disp('exit'); % !!
    end
    
    elemIdx = elemIdx - 1;

end
