function hl = AddLabel(parent, text,   isBold)
%% Add a label on the parent (figure or panel)
% !! Rename this func, because it actually does not create label

% !! Actually, it is always called with isBold == true so I don't need this argument

    global elemIdx

    if nargin == 2
        isBold = false;
    end
    
    assert(~IsMainMenuFigure(parent));  % Dev. assert
    
    hl = uicontrol('Parent', parent, ...
                   'Style', 'text', ...
                   'String', text, ...
                   'FontName', 'Halvetica', ... % !! for consistency with default appdesigner style
                   'FontSize', 9, ...           % !! create a single foo to init FontName and FontSize for different controls
                   'Position', GetElementPosition(elemIdx));
    
    if isBold
        hl.FontWeight = 'bold'; % !!
        hl.FontSize = 12; % !!
    end
    
    elemIdx = elemIdx - 1;
    
end
