function [hef, jwpf] = AddPasswordField(parent, defaultText)
%% Add a password field on the parent (figure or panel)
% !! Call AddEditField from AddPasswordField to create the auxiliary EditField

% !! test: try to close the form when the focus is on each field (sometimes I get "Invalid or deleted object." error)

    global elemIdx
    
    assert(~IsMainMenuFigure(parent));  % Dev. assert
    
    % !! move them to Palette
    jWhite = java.awt.Color(1, 1, 1);
    jGray = java.awt.Color(0.5, 0.5, 0.5);
    jBlack = java.awt.Color(0, 0, 0);
    % !! jTest = java.awt.Color(1, 0, 0); % !!
    
    % !!
    white = [1, 1, 1];
    gray = [0.5, 0.5, 0.5];
    black = [0, 0, 0];
    
    hef = uicontrol('Parent', parent, ...
                    'Style', 'edit', ...
                    'String', defaultText, ...
                    'FontName', 'Halvetica', ...    % !! for consistency with default appdesigner style
                    'FontSize', 9, ...              % !! why not 12 (as in default appdesigner style)? maybe I need to specify: 'Units', 'Pixels'
                    'ForegroundColor', gray, ...
                    'Position', GetElementPosition(elemIdx), ...
                    'UserData', true);  % !! isEmpty
    % !! undocumented
    jtf = findjobj(hef);   % !! 3rdparty. Think about just extracting a piece of code executed for editboxes
                           % !! investigate if it can be adopted for editfield
    
    % !! class(jtf) = 'javahandle_withcallbacks.com.mathworks.hg.peer.EditTextPeer$hgTextField'
    
    jpf = javax.swing.JPasswordField();
    % !! https://www.mathworks.com/matlabcentral/fileexchange/19729-passwordentrydialog
    % !! call of undocumented matlab function
    % !! [jpf, jwpf] = javacomponent(jpf, GetElementPosition(elemIdx) + [15, 15, 0, 0], parent);
    [jpf, jwpf] = javacomponent(jpf, GetElementPosition(elemIdx), parent);

    % !!
    % class(jpf) is 'javahandle_withcallbacks.javax.swing.JPasswordField'
    % class(jwpf) is 'matlab.ui.container.internal.JavaWrapper'

    jpf.setHorizontalAlignment(javax.swing.JTextField.CENTER);

    % The new component is skipped when user traverses through all components pressing the tab key,
    % so we have to enable focus on it explicitly according to the next article:
    % https://undocumentedmatlab.com/blog/fixing-a-java-focus-problem
    % TODO: Try to fix the next inconsistency in behaviour of edit field and password field.
    %       When the focus is switched to an edit field with the tab key, all the text becomes selected,
    %       but when the focus is switched to a password field, the text is not selected.
    jpf.setFocusable(true);
    jpf.putClientProperty('TabCycleParticipant', true);

    % !! how to set the defaultText here (in the case of pre-logged in user)?
    set(jwpf, 'Visible', 'off');

    set(jtf, 'FocusGainedCallback', @TextFocusGainedCallback);
    set(jpf, 'FocusGainedCallback', @PasswordFocusGainedCallback);
    set(jpf, 'FocusLostCallback', @PasswordFocusLostCallback);
    % !!
    % [handles,levels,parentIdx,listing] = findjobj(h);
    
    % !!
    % l = addlistener(h, 'PropertyAdded', @(app, event) FocusGainedCallback(app, event));
    
    % !! Investigate how I can hide the default text when user enters EditField and show it again when user exits it (leaving it empty):
    % See here:
    % https://undocumentedmatlab.com/blog/uicontrol-callbacks
    
    % !! maybe I have to create the old-style figure to be able to attach the enter/exit event handlers
    
    function TextFocusGainedCallback(jTextField, eventdata)
        
        global palette
        
        % disp('TextFocusGainedCallback'); % !!
        % fprintf('EDT: %i\n', javax.swing.SwingUtilities.isEventDispatchThread()); % !!
        set(jwpf, 'Visible', 'on');
        % !! set(jpf, 'Visible', 'on'); % !!
        % jwpf.requestFocus(); % !! no such method
        % !! jpf.requestFocus(); % !! does not work
        % !! javaMethodEDT('requestFocusInWindow', jpf);
        
        % !! https://www.mathworks.com/matlabcentral/answers/98603-how-do-i-force-my-gui-to-give-focus-to-a-specific-uicontrol
        % !! uicontrol(jwpf); % !! error: JavaWrapper cannot be a parent.

        % !!
        % jpf.setBackground(jTest);
                
        drawnow; % !!
        
        % jpf.setFocusable(true); % !! does not work
        % jpf.putClientProperty('TabCycleParticipant', true); % !! does not work
        jpf.requestFocusInWindow(); % !! this works from outside of the Callback
        
        set(hef, 'BackgroundColor', palette.validColor); % !! Reset the "invalid" color if needed
        set(hef, 'Visible', 'off'); % !!
        
        % !! does not work (jumps over the password control)
        %{
        robot = java.awt.Robot();
        tabKeyEvent = java.awt.event.KeyEvent.VK_TAB;
        robot.keyPress(tabKeyEvent);
        robot.keyRelease(tabKeyEvent);
        %}
        
        % !! jpf.grabFocus(); % !! this works from outside of the Callback (and makes the window active)
        % !! jTextField.setVisible(false);
        % disp('exit'); % !!
    end

    function PasswordFocusGainedCallback(jPasswordField, eventdata)
        % !! Reset "invalid" color
        % disp('PasswordFocusGainedCallback'); % !!
        jwpf.JavaPeer.setBackground(jWhite);
    end

    function PasswordFocusLostCallback(jPasswordField, eventdata)
        % disp('PasswordFocusLostCallback'); % !!
        % fprintf('EDT: %i\n', javax.swing.SwingUtilities.isEventDispatchThread()); % !!
        text = jPasswordField.getText();
        if text.isEmpty()
            % disp('making main visible...');
            % get(hef, 'Visible') % !!
            set(hef, 'Visible', 'on');
            % get(hef, 'Visible') % !!
            % !! jtf.setVisible(true); % !!
            % !! jPasswordField.setVisible(false);
            set(jwpf, 'Visible', 'off');
            % !! uicontrol(hef); % !! set focus
        end
        % !! TextFocusGainedCallback();
        % disp('exit'); % !!
    end

    elemIdx = elemIdx - 1;

end
