function hf = CreateFigure(title, numElems)

    global mmLayout
    
    % Check whether we create the main menu figure or a secondary menu figure
    isMain = (nargin == 0);
    assert(isMain || nargin == 2);  % Dev. assert
    
    monPos = get(0, 'MonitorPositions');
    xc = monPos(1, 3);
    yc = monPos(1, 4);
    
    if isMain
        % This is the main figure
        w = 350; % !! move it to mmLayout?
        h = 450;
    else
        % This is a secondary figure
        w = 350 - 2 * mmLayout.f2px; % !! move it to mmLayout?
        h = GetPanelHeight(numElems);
    end
    
    x = (xc - w) / 2;
    y = (yc - h) / 2;
    % !! do I need to specify a parent for secondary figures?
    if isMain
        hf = uifigure('Resize', 'off', ...
                      'Position', [x, y, w, h]);
    else
        % !!
        % We create all not-main figures in the old style to be able to:
        % 1. Make them modal.
        % 2. Add KeyPressFcn and KeyReleaseFcn to editboxes.
        hf = figure('Resize', 'off', ... % !! resize cannot be turned off so simply
                    'NumberTitle', 'off', ...
                    'WindowStyle', 'modal', ... % !!
                    'Tag', 'secondary', ... % !! try to avoid this tag
                    'Position', [x, y, w, h]);
                    % !! add this when the code is not debugged: 'WindowStyle', 'modal', ...
                    % !! however, modality does not preven user from returning to the main figure (which is uifigure)
                    %    so I need to hide and unhide it
    end
                      
    if ~isMain
        hf.Name = title;
        % !! hf.WindowStyle = 'modal';   % Don't allow user to create several instances of the figure
        
        global elemIdx % !! move it upper?
        elemIdx = numElems;
    end
    
end
