function ExposePrimaryFigure()
%% Create and run the main menu GUI
% !! Rename to MenuMain?

    % !! We cannot show secondary figures in the modal mode relative to the primary figure
    %    because the primary figure is created with the new Matlab GUI framework (App Designer) which does not support modal secondaries.
    %    To fix this, consider the usage of the old Matlab GUI framework (GUIDE) for composing the primary figure.
    %    (However, there will be a problem with creation of tabs because the old framework does not support them natively so we will have to use Swing.)
    
    % !! close all; % does not work for uifigure
    
    % Create a new figure in the center of the primary display
    % !! Do I need to create a class as in appdesigner generated code?
    hf = CreateFigure();
    
    % !! parameterize all sizes (create vars)
    
    % !! move colors to Palette
    
    % The maximum number of buttons in a tab
    maxNumBtns = 6;
    
    MainMenuLayout();
    global mmLayout
    
    dy = mmLayout.p2by + mmLayout.bh; % !!
    
    % Main
    hb = uibutton('Parent', hf, ...
                  'Text', 'Start simulation', ...
                  'ButtonPushedFcn', @(btn, event) ButtonPushedFcn(@START_Arachne), ...
                  'BackgroundColor', [0.7, 0.9, 1], ...
                  'FontSize', 20, ...
                  'Position', [40, 80 + dy * maxNumBtns, 240, 50]);
    
    loginDependentButtons = {{hb, true}};
    
    % !! review this icon as well its location in SVN (maybe create "Resources" folder)
    % !! options: 1. use std win10 icon; 2. use Matlab doc icon; 3. use Matlab questdlg icon
    % !! make sure that the icon original size is exactly the same as we show it
    uibutton('Parent', hf, ...
             'Text', '', ...
             'Icon', PrepareIconFileAbsPath('questionMark'), ...
             'ButtonPushedFcn', @(btn, event) ShowHelp(), ...
             'Position', [300, 90 + dy * maxNumBtns, 30, 30]);
    
    % !! move it to indiv file for consisteny (AddTabGroup.m)?
    htg = uitabgroup('Parent', hf, ...
                     'Position', [mmLayout.f2px, mmLayout.f2py, mmLayout.pw, GetPanelHeight(maxNumBtns)]);
    
    % !!??
    % Make it possible to configure the cluster: IP, login, password, registration token
    %       (this data must be saved to registry and loaded from it later)
    
    hta = AddTab('Account', {{'Register',         @RegisterAccount,            false}, ...
                             {'Log in',           @LogInToAccount,             false}, ...
                             {'Log out',          @LogOutOfAccount,            true}, ...
                             {'Change password',  @ChangePasswordFromAccount,  true}, ...
                             {'Recover password', @RecoverPasswordFromAccount, false}, ...
                             {'Delete account',   @DeleteAccount,              true}}, [1, 0.9, 0.8]);
    % !! think about combining Kill and Terminate into one button
    % !! think about making Recover an optional pre-step of Start simulation
    % !! disable buttons dependent on the selected script, then enable them back
    % !! rename "Management" tab to "Simulation"?
    htm = AddTab('Management', {{'Dashboard mockup', @ExposeDashboardFigure}, ...
                                {'Take snapshot',    @SCRIPT_TakeSnapshot,               true}, ...
                                {'Ask to terminate', @SCRIPT_TerminateBackgroundProcess, true}, ...
                                {'Kill',             @SCRIPT_KillBackgroundProcess,      true}, ...
                                {'Recover progress', @SCRIPT_RecoverBackupProgress,      true}, ...
                                {'Clean up',         @SCRIPT_CleanUp,                    true}}, [0.9, 0.9, 1]);
    AddTab('Utilities', {{'Compute max. model size', @UTILITY_ComputeMaxModelSize}, ...
                         {'Plot STDP models',        @UTILITY_PlotStdpModels}}, [0.9, 1, 0.9]); % !! maybe make it darker
    
	% Show that we are not logged in while doing the login request to server
    UpdateViewOnLogInOut(false);
    
    % Try to get the last used user login and password
    lastLoginInfo = GetLastLoginPassword();
    
    if lastLoginInfo.isFound
        % !! Server request (show a message saying that we are loggin in now, show clock cursor)
        [isLoggedIn, ~] = SerReqAccLogIn(lastLoginInfo.login, lastLoginInfo.password);
        % !! some code dup. with ExposeSecFigAccLogIn
        if isLoggedIn
            ShowInfoMessage('You were logged in successfully.', 'Login success'); % !!
            login = lastLoginInfo.login;
            % Focus to "Log Out" here !!
        else
            ShowInfoMessage('You were not logged in.', 'Login failure', true); % !!
        end
    else
        isLoggedIn = false;
    end
    
    if isLoggedIn
        UpdateViewOnLogInOut(true, login);
        htg.SelectedTab = htm;
    else
        login = '';
        htg.SelectedTab = hta;
    end
    
    % !! move it to indiv file for consisteny?
    function ht = AddTab(title, buttonInfos, backgroundColor)
        
        ht = uitab('Parent', htg, ...
                   'Title', title, ...
                   'BackgroundColor', backgroundColor);
        
        global elemIdx % !! move upper?
        elemIdx = maxNumBtns;
        for i = 1 : length(buttonInfos)
            buttonInfo = buttonInfos{i};
            btnText = buttonInfo{1};
            btnHandler = buttonInfo{2};
            hb = AddButton(ht, btnText, @(btn, event) ButtonPushedFcn(btnHandler));
            if length(buttonInfo) == 3
                enableOnLogin = buttonInfo{3};
                loginDependentButtons{end + 1} = {hb, enableOnLogin}; %#ok<AGROW>
            end
        end

    end
    
    function ButtonPushedFcn(foo, varargin)
        % !! Keep the window opened forever, but disable the next three buttons in the case if the simulation is active at the moment:
        %    Start simulation", "Recover progress", "Clean up"
        % !! Do not allow launching two instances of the same script or utility at the same time, because this would lead to collision of global variables.
        % !! Actually, I will have a problem in case of click of any two buttons: (a) global vars will be cleaned, (b) same global vars will be used.
        % !! Close all old plots before starting new simulation
        % !! close(hf);
        foo(varargin{:});
    end
    
    % !! try to use TeX or LaTeX to make list items indentations
    function ShowHelp()
        text = {...
            '{\bfMain button}', ...
            'Start a new Arachne simulation, continue the last finished simulation or take results from it.', ...
            '(You must be logged in to your Arachne account.)', ...
            '', ...
            '{\bfAccount tab}', ...
            '1. Create a new Arachne account (email confirmation is required).', ...
            '2. Log in to your Arachne account.', ...
            '3. Log out of your Arachne account.', ...
            '4. Change password from your Arachne account (email confirmation is required).', ...
            '5. Recover password from your Arachne account (it will be sent by email).', ...
            '6. Delete your Arachne account (email confirmation is required).', ...
            '', ...
            '{\bfManagement tab}', ...
            '1. Show the dashboard mockup.', ...
            '2. Take a progress snapshot from the active simulation (without terminating it).', ...
            '3. Ask the active simulation to terminate (the latest progress will be saved).', ...
            '4. Kill the active simulation (the latest progress will be lost).', ...
            '5. Recover backup progress for abnormally interrupted simulation.', ...
            '6. Clean up all cached files (you will not be able to take results from the last simulation, continue it or recover backup progress).', ...
            '', ...
            '{\bfUtilities tab}', ...
            '1. Compute the maximum network size (i.e. the number of neurons of e-type and i-type) given cluster and simulation parameters.', ...
            '2. Plot spike-timing-dependant plasticity models.', ...
            ''};
        % !! use helpdlg (but it nonmodal)?
        createStruct.Interpreter = 'tex'; % !! or 'latex'?
        createStruct.WindowStyle = 'modal';
        msgbox(text, 'Help', 'help', createStruct);
    end
    
    function RegisterAccount(~, ~)
        % !! Show a new form: email and password
        % !! hf.Visible = 'off';
        loginInfo = ExposeSecFigAccRegister();
        % !! hf.Visible = 'on';
        if loginInfo.isLoggedIn
            % !! Modal msgbox here with info about success, maybe beep (code dup. with compute max model size)
            UpdateViewAndLastUsedCredentialsOnLogInOut(true, loginInfo.login, loginInfo.password); % !!
            login = loginInfo.login;
            ImitateTabKey(1);   % Focus to "Log Out"
        end
    end

    function LogInToAccount(~, ~)
        % !! Show a new form: email and password
        % !! Think about some additional functionality for admin account. Or the functionality will be entirely on the cluster?
        % !! Think about creation of LoginInfo class with two ctors: one for not logged in case, other - for logged in
        loginInfo = ExposeSecFigAccLogIn();
        if loginInfo.isLoggedIn
            % !! Modal msgbox here with info about success, maybe beep
            UpdateViewAndLastUsedCredentialsOnLogInOut(true, loginInfo.login, loginInfo.password); % !!
            login = loginInfo.login;
            ImitateTabKey(1);   % Focus to "Log Out"
        end
    end

    function LogOutOfAccount(~, ~)
        confirmed = AskConfirmation('log out of', 'Logging out');
        if confirmed
            % !! Modal msgbox here with info about success, maybe beep
            UpdateViewAndLastUsedCredentialsOnLogInOut(false);
            ImitateTabKey(6);   % Focus to "Log In"
        end
    end

    function ChangePasswordFromAccount(~, ~)
        confirmed = AskConfirmation('change password from', 'Password change', true);
        if ~confirmed
            return
        end
        % !! Show a new form
        [isChanged, newPassword] = ExposeSecFigAccChange();
        if isChanged
            % !! Modal msgbox here with info about success, maybe beep
            % Update the registry to save user login and password
            % !! need to pass correct login here or create a separate method to change password only
            SetLastLoginPassword(true, login, newPassword);
            ImitateTabKey(7);   % Focus to "Log out"
        end
    end

    % !! usually it is a hyperlink below "Password" field
    % !! would it make sense to look for password in registry first?
    function RecoverPasswordFromAccount(~, ~)
        % !! Show a new form: email
        isRecovered = ExposeSecFigAccRecover();
        if isRecovered
            % !! Modal msgbox here with info about success, maybe beep
            % !! UpdateViewAndLastUsedCredentialsOnLogInOut(true, login, password); % !!
            ImitateTabKey(6);   % Focus to "Log In"
        end
    end

    function DeleteAccount(~, ~)
        confirmed = AskConfirmation('delete', 'Account deletion', true);
        if ~confirmed
            return
        end
        isDeleted = ExposeSecFigAccDelete();
        if isDeleted
            % !! Modal msgbox here with info about success, maybe beep
            UpdateViewAndLastUsedCredentialsOnLogInOut(false);
            ImitateTabKey(2);   % Focus to "Register"
        end
    end

    function confirmed = AskConfirmation(action, title,   byEmail)
    %% Show Yes/No confirmation message box
        
        if nargin == 2
            byEmail = false;
        end
        
        msg = sprintf('Are you sure want to %s your Arachne account?', action);
        if byEmail
            msg = {msg, ...
                   '(Confirmation token will be sent by email.)'};
        end
        
        btnName = questdlg(msg, title, ...
                           'Yes', 'No', ...
                           'No');
        confirmed = strcmp(btnName, 'Yes');
    end

    function UpdateViewOnLogInOut(isLoggedIn,   login)
    %% Depending on user login state, change figure title and enable/disable buttons
        
        assert(nargin == 2 || (nargin == 1 && isLoggedIn == false));    % Dev. assert
        
        namePat = 'Arachne (%s)';
        if isLoggedIn
            name = sprintf(namePat, login);
        else
            name = sprintf(namePat, 'not logged in');
        end
        hf.Name = name;
        
        for i = 1 : length(loginDependentButtons)
            button = loginDependentButtons{i};
            hb = button{1};
            enableOnLogin = button{2};
            hb.Enable = TrueFalseToOnOff(isLoggedIn == enableOnLogin);
        end
        
    end

    function UpdateViewAndLastUsedCredentialsOnLogInOut(isLoggedIn,   login, password)
    %% Depending on user login state, change figure title and enable/disable buttons.
    %  Save the state to !!registry.
        
        assert(nargin == 1 || nargin == 3); % Dev. assert
        if nargin == 1
            assert(isLoggedIn == false);    % Dev. assert
            login = '';
            password = '';
        end
        
        UpdateViewOnLogInOut(isLoggedIn, login);
    
        % Update the registry to save user login and password
        SetLastLoginPassword(isLoggedIn, login, password);
        
    end

end

% !! for some reason, it does not restart the loop on the top element after leaving the last one
function ImitateTabKey(numClicks)
% As App Designer does not support programmatic focus switching at the moment, we have to imitate the tab key click
% in order to move the focus to correct uicontrol
% https://www.mathworks.com/matlabcentral/answers/353504-give-focus-to-an-edit-field
% https://www.mathworks.com/matlabcentral/answers/527-artificial-simulated-key-press
    robot = java.awt.Robot();
    tabKeyEvent = java.awt.event.KeyEvent.VK_TAB;
    for i = 1 : numClicks
        robot.keyPress(tabKeyEvent);
        % For some reason, robot.keyPress does all the work.
        % We don't call robot.keyRelease here because it works as the second tab click.
        % robot.keyRelease(tabKeyEvent);
    end
end
