function [isChanged, newPassword] = ExposeSecFigAccChange()
%% Expose the secondary figure for Account\Change

    hf = CreateFigure('Change password', 7);
    
    AddLabel(hf, 'Change password', true);
    [h11, h12] = AddPasswordField(hf, 'Old Password');
    [h21, h22] = AddPasswordField(hf, 'New Password');
    [h31, h32] = AddPasswordField(hf, 'Confirm New Password');
    h4 = AddButton(hf, 'Send Token', @SendTokenPushedFcn);
    h5 = AddEditField(hf, 'Token'); % !! actually, it's not a "Token" in a common sense
    h6 = AddButton(hf, 'Change Password', @ChangePasswordPushedFcn);
    
    set(h5, 'Enable', 'off');
    set(h6, 'Enable', 'off');
    
    isChanged = false;
    newPassword = '';
    
    uiwait(hf);
    
    function SendTokenPushedFcn(app, event)
        % !! Apply the login and password pre-validation policy here (the final validation + check for uniqueness will be in the manager)
        
        data = {{@ValPredPasswordOld, [h11, h12]}, ...
                {@ValPredPasswordNew, [h11, h12], [h21, h22]}, ...
                {@ValPredPasswordConfirm, [h21, h22], [h31, h32]}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        newPassword = char(h22.JavaPeer.getText());
        
        % !! Request to manager here
        % !! Rename to ChangeRequest?
        success = SerReqAccChangeSendToken(newPassword);
        ShowConfirmationTokenMessage(success);
        if ~success
            return
        end
        
        DisablePasswordField(h12);
        DisablePasswordField(h22);
        DisablePasswordField(h32);
        set(h4, 'Enable', 'off');
        
        set(h5, 'Enable', 'on');
        set(h6, 'Enable', 'on');
    end
    
    function ChangePasswordPushedFcn(app, event)
        
        data = {{@ValPredToken, h5}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        token = get(h5, 'String');
        
        % !! Request to manager here
        isChanged = SerReqAccChangeConfirm(token);
        
        if isChanged
            ShowInfoMessage('The password was changed successfully.', 'Password change success'); % !! use the error message style in the case of error
        else
            ShowInfoMessage('The password was not changed.', 'Password change failure', true); % !!
            return
        end
        
        close(hf);
    end
    
end
