function loginInfo = ExposeSecFigAccLogIn()
%% Expose the secondary figure for Account\Log In

    hf = CreateFigure('Log in', 4);
    
    AddLabel(hf, 'Log in to your Arachne account', true);
    h1 = AddEditField(hf, 'Login or Email');
    [h21, h22] = AddPasswordField(hf, 'Password');
    % !! check button text style everywhere: now we have both 'Log in' and 'Log In'
    AddButton(hf, 'Log In', @LogInPushedFcn);
    
    loginInfo = struct('isLoggedIn', false);
    
    uiwait(hf);
    
    function LogInPushedFcn(app, event)
        
        data = {{@ValPredLoginOrEmail, h1}, ...
                {@ValPredPassword, [h21, h22]}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        loginOrEmail = get(h1, 'String');
        password = char(h22.JavaPeer.getText());
        
        % !! Request to manager here
        % !! should it return email instead of login?
        [success, login] = SerReqAccLogIn(loginOrEmail, password); % !!
        
        if success
            ShowInfoMessage('You were logged in successfully.', 'Login success'); % !!
        else
            ShowInfoMessage('You were not logged in.', 'Login failure', true); % !!
            return
        end
        
        loginInfo = struct('isLoggedIn', true, ...
                           'login', login, ...
                           'password', password);
        
        close(hf);
        
    end
    
end
