function isRecovered = ExposeSecFigAccRecover()
%% Expose the secondary figure for Account\Recover

    % !! think about the workflow in this scenario taking into scope that server contains hashes rather than passwords
    
    hf = CreateFigure('Recover password', 3);
    
    AddLabel(hf, 'Send the password by email', true);
    h1 = AddEditField(hf, 'Login or Email');
    AddButton(hf, 'Send', @SendPushedFcn);
    
    % !! Alternative way (for the case when server stores hashes rather than passwords)
    %{
    hf = CreateFigure('Reset password', 6);
    
    AddLabel(hf, 'Reset password', true);
    h1 = AddButton(hf, 'Send Token', @SendTokenPushedFcn);
    h2 = AddEditField(hf, 'Token');
    [h31, h32] = AddPasswordField(hf, 'New Password');
    [h41, h42] = AddPasswordField(hf, 'Confirm New Password');
    h5 = AddButton(hf, 'Change Password', @ChangePasswordPushedFcn);
    
    set(h2, 'Enable', 'off');
    set(h31, 'Enable', 'off');
    set(h41, 'Enable', 'off');
    set(h5, 'Enable', 'off');
    %}
    
    isRecovered = false;
    
    uiwait(hf);
    
    function SendPushedFcn(app, event)
        
        data = {{@ValPredLoginOrEmail, h1}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        loginOrEmail = get(h1, 'String');
        
        % !! Request to manager here
        isRecovered = SerReqAccRecover(loginOrEmail);
        
        if isRecovered
            ShowInfoMessage('The email was sent successfully.', 'Recovery success'); % !! use the error message style in the case of error
            % !! propose user to login here?
        else
            ShowInfoMessage('The email was not sent.', 'Recovery failure', true); % !!
            return
        end
        
        close(hf);
    end
    
end
