function loginInfo = ExposeSecFigAccRegister()
%% Expose the secondary figure for Account\Register
%  !! When we have the active server with REST API, the token-based confirmation can be replaced with a confirmation hyperlink

    hf = CreateFigure('Register', 8);
    
    AddLabel(hf, 'Create a new Arachne account', true);
    h1 = AddEditField(hf, 'Login');
    [h21, h22] = AddPasswordField(hf, 'Password');
    [h31, h32] = AddPasswordField(hf, 'Confirm Password'); % !! why does it jumps down by 1 pixel on focus on home pc?
    h4 = AddEditField(hf, 'Email');
    h5 = AddButton(hf, 'Send Token', @SendTokenPushedFcn);
    h6 = AddEditField(hf, 'Token'); % !! actually, it's not a "Token" in a common sense
    h7 = AddButton(hf, 'Register Account', @RegisterAccountPushedFcn);
    
    set(h6, 'Enable', 'off');
    set(h7, 'Enable', 'off');
    
    loginInfo = struct('isLoggedIn', false);
    
    uiwait(hf);
    
    function SendTokenPushedFcn(app, event)
        % !! Apply the login and password pre-validation policy here (the final validation + check for uniqueness will be in the manager)
        
        data = {{@ValPredLogin, h1}, ...
                {@ValPredPassword, [h21, h22]}, ...
                {@ValPredPasswordConfirm, [h21, h22], [h31, h32]}, ...
                {@ValPredEmail, h4}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        login = get(h1, 'String');
        password = char(h22.JavaPeer.getText());
        email = get(h4, 'String');
        
        % !! Request to manager here
        % !! Rename to RegistrationRequest?
        % !! Do I need to use case-sensitive email comparison on server side?
        success = SerReqAccRegisterSendToken(login, password, email);
        ShowConfirmationTokenMessage(success);
        if ~success
            return
        end
        
        loginInfo.login = login;
        loginInfo.password = password;
        
        set(h1, 'Enable', 'off');
        DisablePasswordField(h22);
        DisablePasswordField(h32);
        set(h4, 'Enable', 'off');
        set(h5, 'Enable', 'off');
        
        set(h6, 'Enable', 'on');
        set(h7, 'Enable', 'on');
    end
    
    function RegisterAccountPushedFcn(app, event)
        
        data = {{@ValPredToken, h6}};
        success = PreValidateFields(data);
        if ~success
            return
        end
        
        token = get(h6, 'String');
        
        % !! Request to manager here
        success = SerReqAccRegisterConfirm(token);
        
        if success
            % !! Show a messagebox saying that the registration is successful
            msg = {'Your account is registered successfully.'};
            title = 'Registration complete';
            ShowInfoMessage(msg, title);
        else
            ShowInfoMessage('The account was not registered.', 'Registration failure', true); % !!
            return
        end
        
        loginInfo.isLoggedIn = true;
        
        close(hf);
        
    end
    
end
