function pos = GetElementPosition(elemIdx)
%% Get position (in pixels) of a GUI element (button, edit field or label) with the specified index on the parent (figure or panel)
%  pos = [x, y, w, h]
%  where x and y correspond to the lower-left corner of the GUI element

    global mmLayout
    
    assert(elemIdx >= 1);   % Dev. assert
    
    pos = [mmLayout.p2bx, GetElemY(elemIdx), mmLayout.bw, mmLayout.bh]; % !! elem, not btn
    
end

function y = GetElemY(elemIdx)
%% Get Y coordinate of the lower edge

    global mmLayout
    
    y = mmLayout.p2by * elemIdx + mmLayout.bh * (elemIdx - 1); % !! elem, not btn
    
end
