function [valid, hint] = ValPredPasswordNew(password1, password2)
%% Validation predicate for "New Password" field

    name = 'New Password';
    
    valid = ~strcmp(password1, password2);
    if ~valid
        hint = sprintf('%s (must not be the same as Old Password)', name);
        return
    end
    
    [valid, hint] = ValPredPassword(password2);
    hint = strrep(hint, 'Password', name);
    
end
