function [valid, hint] = ValPredPasswordOld(password)
%% Validation predicate for "Old Password" field

    lastLoginInfo = GetLastLoginPassword();
    assert(lastLoginInfo.isFound);  % Dev. assert
    
    valid = strcmp(password, lastLoginInfo.password);
    if ~valid
        hint = 'Old Password';
        return
    end
    
    hint = '';
    
end
