function SCRIPT_CleanUp()
%% Clean up HPC kernel I/O directories.
%  (This entry point is for both desktop and mobile versions of Matlab.)

    % !! clean global vars
    
    clc;
    
    AddPaths();
    
    BasicParams();
    
    foo = @SCRIPT_Core;
    CallWithErrorHandlingPolicy(foo, 'Error', true);
    
end

function SCRIPT_Core()
%%

    global continuationMode
    global terminateOrKillScenarioMsg
    
    % Make sure that the kernel is not running at the moment
    isRunning = CheckIfRunning();
    if isRunning
        msgPat = [...
            'Cannot clean up HPC kernel I/O directories because simulation is running at the moment.\n', ...
            'Please wait until it completes or %s to stop the simulation and then try to do cleanup once again.'];
        error(msgPat, terminateOrKillScenarioMsg);
    end
    
    % Do cleanup
    continuationMode = false;
    CleanUpIODirs();
    
    disp('Done.');
    
    % !! pause in compiled mode
    
end
