function SCRIPT_RecoverBackupProgress()
%% Recover simulation progress from the latest backup file(s).
%  The files "output.mat" and "intermediate.mat" are subjects of recovering.
%  (This entry point is for both desktop and mobile versions of Matlab.)

    % !! clean global vars
    
    clc;
    
    AddPaths();
    
    BasicParams();

    foo = @SCRIPT_Core;
    CallWithErrorHandlingPolicy(foo, 'Error', true);
    
end

function SCRIPT_Core()
%%

    global mainScenarioMsg
    
    % Make sure that the kernel is not running at the moment
    isRunning = CheckIfRunning();
    if isRunning
        error('Cannot restore backup progress files until Arachne is running.');
    end

    % Select backup storage (1 or 2) to recover from
    disp('Selecting backup storage (1 or 2) to recover from ...');
    idx = SelectBackupStorage();
    fprintf('Backup storage %i will be used for recovery.\n', idx);

    % Recover files "output.mat" and "intermediate.mat" (if present) from the backup storage
    isIntermPresent = RecoverMatFiles(idx);
    
    disp('Recovery complete.');
    str = sprintf('Now you can %s to grab simulation results', mainScenarioMsg);
    if isIntermPresent
        disp([str, ' or continue simulation from the backup point.']);
    else
        disp([str, '.']);
    end
    
    % !! pause in compiled mode
    
end