function START_INSTALLED_Arachne()
%% Entry point for the installed version of Arachne

    clc; % !!
    
    assert(ispc);
    
    % Make sure that we have the toolbox used by Dashboard GUI
    reqToolboxName = 'Widgets Toolbox';
    %{
    toolboxes = matlab.addons.toolbox.installedToolboxes;
    cond = length(toolboxes) == 1 && strcmp(toolboxes(1).Name, reqToolboxName);
    %}
    % !! The commented code fails in the installed Arachne with the next error:
    % Undefined variable "matlab" or class "matlab.addons.toolbox.installedToolboxes".
    % Error in START_INSTALLED_Arachne (line 11)
    % MATLAB:undefinedVarOrClass
    cond = exist('uiw.widget.Tree', 'class') == 8 && exist('uiw.widget.TreeNode', 'class') == 8;
    msgPat = '\nPlease install <a href="https://www.mathworks.com/matlabcentral/fileexchange/66235-widgets-toolbox">%s</a>';
    assert(cond, msgPat, reqToolboxName);
    
    % Determine whether we are in the installed version of Arachne or just run the code in Matlab IDE
    global installedMode
    installedMode = isdeployed;
    
    if installedMode
        SetUpDirsForInstalledMode();
    end
    
    AddPaths();
    
    BasicParams();  % !! don't call it here. I just need debugMode and mobileMode for CallWithErrorHandlingPolicy
    Palette();      % !! don't call it here. I just need palette.invalidColor
    
    ExposePrimaryFigure();
    
end

function SetUpDirsForInstalledMode()
%% Set the current working directory, prepare two new directories used by host, set the global struct containing all paths

    global hostDirPaths
    
    % Change the work directory, because it can be either desktop (if user launched the application by clicking the desktop icon) or
    % any other directory (if user set some value to "Start in" application property)
    installLocation = GetInstallLocation();
    hostCodeDir = fullfile(installLocation, 'application');
    cd(hostCodeDir);
    
    % Prepare the next two folders for IO data and Temp data respectively.
    % Windows Vista, 7, 8, 10 paths:
    %   C:\Users\{username}\Documents\Arachne
    %   C:\Users\{username}\AppData\Local\Temp\Arachne
    % Windows XP paths:
    %   C:\Documents and Settings\{username}\My Documents\Arachne
    %   C:\Documents and Settings\{username}\Local Settings\Temp\Arachne
    % Useful hyperlinks:
    %   https://stackoverflow.com/questions/3492920/is-there-a-system-defined-environment-variable-for-documents-directory
    %   https://social.technet.microsoft.com/wiki/contents/articles/6083.windows-xp-folders-and-locations-vs-windows-7-and-vista.aspx
    %   https://en.wikipedia.org/wiki/Environment_variable#Default_values
    
    personalLocation = GetPersonalLocation();
    hostIODir = PrepareArachneSubDir(personalLocation, false);  % Do not clean if exists
    
    tempLocation = GetTempLocation();
    hostTempDir = PrepareArachneSubDir(tempLocation, true);     % Clean if exists
    
    % Store the paths to use later
    hostDirPaths = struct('Code', hostCodeDir, ...
                          'IO',   hostIODir, ...
                          'Temp', hostTempDir);
    
end

function subDirPath = PrepareArachneSubDir(parentDirPath, needEmpty)
%% Prepare "Arachne" subfolder in the specified parent folder

    assert(exist(parentDirPath, 'dir') == 7);
    
    subDirPath = fullfile(parentDirPath, 'Arachne');
    if needEmpty
        PrepareEmptyDir(subDirPath);
    else
        status = exist(subDirPath, 'dir');
        if status ~= 7
            assert(status == 0);
            [success, message, ~] = mkdir(subDirPath);
            if ~success
                error(message);
            end
        end
    end
    
end
