function [blocks, freeLocalVars] = ParseModFile(path)

    modKeywords = {
        'TITLE', ...
        'NEURON', ...
        'CONSTANT', ...
        'PARAMETER', ...
        'UNITS', ...
        'ASSIGNED', ...
        'STATE', ...
        'BREAKPOINT', ...
        'INITIAL', ...
        'FUNCTION', ...
        'DERIVATIVE', ...
        'PROCEDURE', ...
        'KINETIC', ...
        'DEFINE'};
 
    modFile = fopen(path);
    if modFile == -1
        error('Cannot open file for reading');
    end

    blocks = RunIncludePreprocessor(path, modKeywords);
    
    numBlocks = zeros(size(modKeywords));

    line = fgetl(modFile);

    while ischar(line) || isempty(line)

        found = false;
        for idx = 1 : length(modKeywords)

            if strfind(line, modKeywords{idx})

                found = true;

                lines = {};
                lines{end + 1, 1} = line; %#ok<AGROW>
                line = fgetl(modFile);

                while ischar(line) || isempty(line)

                    containKeyword = false;

                    for j = 1 : length(modKeywords)
                        if ~isempty(strfind(line, modKeywords{j})) && isempty(strfind(line, 'UNITSOFF'))
                            containKeyword = true;
                            break
                        end
                    end

                    if containKeyword
                        break
                    end

                    lines{end + 1, 1} = line; %#ok<AGROW>

                    line = fgetl(modFile);

                end

                numBlocks(idx) = numBlocks(idx) + 1;

                rigthBorder = 1;
                lenLines = length(lines);
                for k = 0 : lenLines - 1
                    if strfind(lines{lenLines - k}, '}')
                        rigthBorder = lenLines - k;
                        break
                    end
                end

                cleanLines = {};

                for k = 1 : rigthBorder
                    cleanLines{end + 1, 1} = lines{k}; %#ok<AGROW>
                end

                if strcmp(modKeywords{idx}, 'PROCEDURE') || strcmp(modKeywords{idx}, 'FUNCTION')
                    field = blocks.(modKeywords{idx});
                    field{numBlocks(idx)} = cleanLines;
                    blocks.(modKeywords{idx}) = field;
                else
                    blocks.(modKeywords{idx}) = cleanLines;
                end
                
            end
        end
        if ~found
            line = fgetl(modFile);
        end
    end   
    fclose(modFile);
    
    freeLocalVars = GetFreeLocalVars(path);
    
end

function blocks = RunIncludePreprocessor(path, modKeywords)

    modFile = fopen(path, 'r');
    if modFile == -1
        error('Cannot open file for reading');
    end
    
    blocks = struct();
    for idx = 1 : length(modKeywords)
        blocks.(modKeywords{idx}) = {};
    end
    
    lines = {};
    while ~feof(modFile)
        
        line = fgetl(modFile);
        keywordsIdx = -1; %#ok<NASGU>
        if strfind(line, 'INCLUDE')
            idx = strfind(line, '"');
            leftIdx = idx(1) + 1;
            rightIdx = idx(end) - 1;

            nameIncludeFile = line(leftIdx : rightIdx);       
            idx = strfind(path, '\');
            pathToIncludeMod = [path(1 : idx(end)), nameIncludeFile];
            
            includeLines = ProcessIncludeDirective(pathToIncludeMod);
            
            found = false;
            for k = 1 : length(includeLines)
                line = includeLines{k};
                if ~found
                    for idx = 1 : length(modKeywords)
                        if strfind(line, modKeywords{idx})
                            keywordsIdx = idx; %#ok<NASGU>
                            found = true;
                            break
                        end
                    end
                end
                
                if found
                    lines{end + 1, 1} = line; %#ok<AGROW>
                end
            end
            
            if strcmp(modKeywords{idx}, 'PROCEDURE') || strcmp(modKeywords{idx}, 'FUNCTION')
                field = blocks.(modKeywords{idx});
                field{end + 1} = lines; %#ok<AGROW>
                blocks.(modKeywords{idx}) = field;
            else
                blocks.(modKeywords{idx}) = lines;
            end
    
            lines = {};
        end
    end 
    fclose(modFile);
end

function lines = ProcessIncludeDirective(filePathName)

    pathIdx = strfind(filePathName, '\');
    pathIdx = pathIdx(end) - 1;
    tmpPathName = filePathName(1 : pathIdx);
    lines = {};
    fid = fopen(filePathName);
    assert(fid ~= -1);
    while ~feof(fid)
        cline = fgetl(fid);
        lines = ProcessIncludeDirectivesRecursively(lines, cline, tmpPathName);
    end  
    fclose(fid);
end

function vars = GetFreeLocalVars(path)
    
    vars = {};
    modFile = fopen(path, 'r');
    if modFile == -1
        error('Couldn''t open the next file for reading:\n%s', path);
    end
    
    checksum = 0;
    isComment = false;
    while ~feof(modFile)

        line = fgetl(modFile);
        
        if strcmp(line, 'COMMENT')
            isComment = true;
        elseif strcmp(line, 'ENDCOMMENT')
            isComment = false;
            continue
        end
        
        if isComment
            continue
        end
        
        leftScope = strfind(line, '{');  
        if ~isempty(leftScope)
            checksum = checksum + length(leftScope);
        end

        rightScope = strfind(line, '}');
        if ~isempty(rightScope)
            checksum = checksum - length(rightScope);
        end
              
        if checksum == 0 && ~isempty(strfind(line, 'LOCAL'));  
            vars{end + 1, 1} = line; %#ok<AGROW>
        end    
    end
    
    if isempty(vars)
        return
    end
    
    for i = 1 : length(vars)
        tmpStr = strsplit(vars{i}, ':');
        vars{i} = ['    ', strtrim(regexprep(tmpStr{1}, 'LOCAL', 'T')), ';']; %#ok<AGROW>
    end
end