function GenerateHdrFile(modFileName, parametersBlocks, freeLocalVars, out_path, user_init_params)

    hdrTplPathName = fullfile(cd, 'Core', 'ModFileUtils', 'CppFilesGenerators', 'Templates', 'HdrTemplate.h');

    hdrTplFile = fopen(hdrTplPathName, 'r');

    if hdrTplFile == -1
        error('Couldn''t open the next file for reading:\n%s', hdrTplPathName);
    end

    hdrFile = {};
    tline = fgetl(hdrTplFile);
    hdrFile{end + 1, 1} = tline;

    while true

        tline = fgetl(hdrTplFile);

        if tline == -1
            break
        end

        if strfind(tline, '%DEFINES')
            
            defineParams = parametersBlocks.DEFINE;
            
            if ~isempty(defineParams)
                hdrFile{end + 1, 1} = ''; %#ok<AGROW>
            end
            
            for idx = 1 : length(defineParams)
                hdrFile{end + 1, 1} = regexprep(defineParams{idx}, 'DEFINE', '#define'); %#ok<AGROW>
            end
            
            if ~isempty(defineParams)
                hdrFile{end + 1, 1} = ''; %#ok<AGROW>
            end
            
        elseif strfind(tline, '%CLASS_NAME')

            hdrFile{end + 1, 1} = ['class ', modFileName, ' : public AtomicModCurrentBase<T>']; %#ok<AGROW>

        elseif strfind(tline, '%CTOR_DECLARATION')
            
            hdrFile{end + 1, 1} = ['    ', modFileName, '();']; %#ok<AGROW>
            
        elseif strfind(tline, '%LOCAL_PARAMS')
            
            if ~isempty(freeLocalVars)
                for i = 1 : length(freeLocalVars)
                    hdrFile{end + 1, 1} = freeLocalVars{i}; %#ok<AGROW>
                end
            end
            
        elseif strfind(tline, '%CONST_PARAMS')
            
            params = ParseParameterBlock(parametersBlocks.CONSTANT);
            
            for i = 1 : length(params)
                str = strtrim(params{i});
                if ~isempty(strfind(str, '='))
                    % The const modifier is commented here, because otherwise
                    % the current logic of deserialization would not compile
                    hdrFile{end + 1, 1} = ['    /* const */ T ', str, ';']; %#ok<AGROW>
                end
            end
            
        elseif strfind(tline, '%PARAMS')

            params = ParseParameterBlock(parametersBlocks.PARAMETER);

            for i = 1 : length(params)

                str = strtrim(params{i});
                
                if strcmp(str, 'v') || strcmp(str, 't')
                    continue
                end

                if isempty(strfind(str, '='))                 
                    var_names = user_init_params.varname;
                    var_values = user_init_params.varvalue;
                    for k = 1 : length(var_names)
                        if strcmp(str, var_names{k})
                            hdrFile{end + 1, 1} = ['    T ', str, ' = (T)', num2str(var_values{k}), ';']; %#ok<AGROW>
                        end
                    end
                else
                    split_param = strsplit(str, '=');
                    hdrFile{end + 1, 1} = ['    T ', strtrim(split_param{1}), ' = (T)' , strtrim(split_param{2}), ';']; %#ok<AGROW>
                end
            end

        elseif strfind(tline, '%STATE_PARAMS')
            
            params = ParseStateBlock(parametersBlocks.STATE);
            if ~isempty(params)
                cline = '';
                lenParams = length(params);
                for k = 1 : lenParams - 1
                    cline = [cline, params{k}, ', ']; %#ok<AGROW>
                end
                hdrFile{end + 1, 1} = ['    T ', cline, params{lenParams}, ';']; %#ok<AGROW>
            end
            
        elseif strfind(tline, '%ASSIGNED_PARAMS')
            
            params = ParseAssignedBlock(parametersBlocks.ASSIGNED);
            if ~isempty(params)
                cline = '';
                lenParams = length(params);
                for k = 1 : lenParams - 1
                    cline = [cline, params{k}, ', ']; %#ok<AGROW>
                end
                hdrFile{end + 1, 1} = ['    T ', cline, params{lenParams}, ';']; %#ok<AGROW>
            end
            
        elseif strfind(tline, '%DERIVATIVE_DECLARATION')

            params = ParseStateBlock(parametersBlocks.STATE);

            if ~isempty(params)
                cline = '';
                len_params = length(params);
                for k = 1 : len_params - 1
                    if isempty(strfind(params{k}, '['))
                        cline = [cline, params{k}, '_rhp, ']; %#ok<AGROW>
                    end
                end

                if isempty(strfind(params{len_params}, '[')) 
                    hdrFile{end + 1, 1} = ['    T ', cline, params{len_params}, '_rhp;']; %#ok<AGROW>
                elseif ~isempty(cline)
                    hdrFile{end + 1, 1} = ['    T ', cline, '_rhp;']; %#ok<AGROW>
                end
            end
            
        elseif strfind(tline, '%PROCEDURE_DECLARATIONS')

            for idx = 1 : length(parametersBlocks.PROCEDURE)

                proc = parametersBlocks.PROCEDURE{idx};
                [name, formal_params] = ParseProcedureBlock(proc);
                
                if isempty(formal_params{1})
                    hdrFile{end + 1, 1} = ['    void ', name, '();']; %#ok<AGROW>
                else 
                    var_names = '';
                    for i = 1 : length(formal_params) - 1
                        var_names = [var_names, 'T ', formal_params{i}, ', ']; %#ok<AGROW>
                    end
                    var_names = [var_names, 'T ', formal_params{end}]; %#ok<AGROW>
                    hdrFile{end + 1, 1} = ['    void ', name, '(', var_names, ');']; %#ok<AGROW>
                end
            end

        elseif strfind(tline, '%FUNCTION_DECLARATIONS')

            for idx = 1 : length(parametersBlocks.FUNCTION)
                
                func = parametersBlocks.FUNCTION{idx};
                [name, formal_params] = ParseFunctionBlock(func);
                
                if isempty(formal_params{1})
                    hdrFile{end + 1, 1} = ['    T ', name, '();']; %#ok<AGROW>
                else
                    var_names = '';
                    for i = 1 : length(formal_params) - 1
                        var_names = [var_names, 'T ', formal_params{i}, ', ']; %#ok<AGROW>
                    end
                    var_names = [var_names, 'T ', formal_params{end}]; %#ok<AGROW>
                    hdrFile{end + 1, 1} = ['    T ', name, '(', var_names, ');']; %#ok<AGROW>
                end
            end

        else
            hdrFile{end + 1, 1} = tline; %#ok<AGROW>
        end

    end

    fclose(hdrTplFile);

    SaveLinesToFile(hdrFile, out_path, [modFileName, '.h']);
    
end
