function buttonName = QuestDlg(dialogId, question,   title, btn1, btn2, varargin)
%% Get user's answer to the given question.
%  This is basically a wrapper of "questdlg" function that supports a predefined choice.
%  If we are called from Matlab mobile, then the predefined choice is required,
%  because Matlab mobile does not support interaction with user at runtime.

    global DialogIds
    global userChoices mobileMode
    
    if nargin > 6
        % The last argument is "default"
        btn3 = varargin{1};
    end
        
    % Try to get a predefined answer
    fieldName = GetFieldName(DialogIds, dialogId);
    try
        buttonName = userChoices.(fieldName);
        pa = true;
    catch
        pa = false;
    end
    
    if mobileMode || pa
        % Print the question
        disp(question);
        
        % Print the options
        disp('The options are:');
        pat = '    ''%s''\n';
        if nargin >= 4
            fprintf(pat, btn1);
        end
        if nargin >= 5
            fprintf(pat, btn2);
        end
        if nargin >= 6
            fprintf(pat, btn3);
        end
    end
    
    if mobileMode && dialogId == DialogIds.ImageSource
        % The image source is not selectable in the mobile mode
        buttonName = 'Load';
        pa = true;
    end
    
    if pa
        % Print the predefined answer
        pat = 'Your choice is: ''%s''\n\n';
        fprintf(pat, buttonName);
    else
        if mobileMode
            % Close the question line and add a blank line
            fprintf('\n\n');
            
            % Interaction with user is impossible
            UserChoiceError(fieldName);
        else
            % The interaction
            buttonName = questdlg(question, title, btn1, btn2, varargin{:});
        end
    end
    
end
