function SCRIPT_RecoverBackupProgress()
%% Recover simulation progress from the latest backup file(s).
%  The files "output.mat" and "intermediate.mat" are subjects of recovering.

    AddPaths();
    
    BasicParams();
    
    % Make sure that the kernel is not running at the moment
    isRunning = CheckIfRunning();
    if isRunning
        error('Cannot restore backup progress files until Arachne is running.');
    end

    % Select backup storage (1 or 2) to recover from
    disp('Selecting backup storage (1 or 2) to recover from ...');
    idx = SelectBackupStorage();
    fprintf('Backup storage %i will be used for recovery.\n', idx);

    % Recover files "output.mat" and "intermediate.mat" (if present) from the backup storage
    isIntermPresent = RecoverMatFiles(idx);
    
    disp('Recovery complete.');
    str = 'Now you can launch the script "START_Arachne.m" to grab simulation results';
    if isIntermPresent
        disp([str, ' or continue simulation from the backup point.']);
    else
        disp([str, '.']);
    end

end