#include "BasicCurrent.h"


// First part of the midpoint method step
template <typename T>
void BasicCurrent<T>::DoOneStepPart1(const DistVector<T> &v)
{
    using namespace DistEnv;

    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(v.localLength, startIdx, endIdx);

    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T m = (this->*m_inf)(v[idx]);

        I[idx] = basicCurrentFactor * (c1 * pow(n[idx], 4) * (c2 - v[idx]) + c3 * pow(m, 3) * h[idx] * (c4 - v[idx]));

        T n_inc = ((this->*n_inf)(v[idx]) - n[idx]) / (this->*tau_n)(v[idx]);
        T h_inc = ((this->*h_inf)(v[idx]) - h[idx]) / (this->*tau_h)(v[idx]);

        n_tmp[idx] = n[idx] + dt05 * n_inc;
        h_tmp[idx] = h[idx] + dt05 * h_inc;
    }
}
