#pragma once

#include "Containers/DistVector.h"
#include "MatFileIO/MatFileIOUtils.h"

template <typename T>
class BasicCurrent
{

public:
    // The current itself
    DistVector<T> I;

public:

    // Constructors

    BasicCurrent() = default;

    BasicCurrent(char suffix, T dt, T basicCurrentFactor, int num);

    // Public methods
    void GatherWriteIntermediateData();
    void DoOneStepPart1(const DistVector<T> &v);
    void DoOneStepPart2(const DistVector<T> &v_tmp);

private:
    void ReadInputDataAllocateTemporaryArrays(int num);

private:
    // "e" or "i"
    std::string suffix;

    // Floating-point scalars
    T dt, dt05;
    T c1, c2, c3, c4;
    T basicCurrentFactor;

    // Distributed vectors
    DistVector<T> n, h;
    DistVector<T> n_tmp, h_tmp;

    // Local vectors for gathered data saved to "intermediate.mat"
    LocalVector<T> n_local, h_local;

    // Kinetic parameters (dependent on neuron type)
    T h_v_1, m_v_1, n_v_1;
    T h_v_2, m_v_2, n_v_2;
    T h_a_1, m_a_1, n_a_1;
    T h_a_2, m_a_2, n_a_2;
    T h_b_1, m_b_1, n_b_1;
    T h_b_2, m_b_2, n_b_2;
    T phi;  // Used for i-neurons only

    // Kinetic functions (dependent on neuron type)
    typedef T(BasicCurrent<T>::*MembFuncPtr)(T v);
    MembFuncPtr h_inf;
    MembFuncPtr m_inf;
    MembFuncPtr n_inf;
    MembFuncPtr tau_h;
    MembFuncPtr tau_n;

    // Declarations of all available kinetic functions (for both neuron types)
    T h_e_inf(T v);
    T h_i_inf(T v);
    T m_e_inf(T v);
    T m_i_inf(T v);
    T n_e_inf(T v);
    T n_i_inf(T v);
    T tau_h_e(T v);
    T tau_h_i(T v);
    T tau_n_e(T v);
    T tau_n_i(T v);
};

// Definitions of member functions
#include "Kinetic/h_e_inf.h"
#include "Kinetic/h_i_inf.h"
#include "Kinetic/m_e_inf.h"
#include "Kinetic/m_i_inf.h"
#include "Kinetic/n_e_inf.h"
#include "Kinetic/n_i_inf.h"
#include "Kinetic/tau_h_e.h"
#include "Kinetic/tau_h_i.h"
#include "Kinetic/tau_n_e.h"
#include "Kinetic/tau_n_i.h"