#include "AstroNet.h"

template <typename T, typename RNGT>
void AstroNet<T, RNGT>::CorrectReleaseProbabilities(int iter)
{
    using namespace DistEnv;
    
    Ca.Gather(Ca_buf);
    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(Ca_buf.length, startIdx, endIdx);
    
    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T p = CumputeReleaseProbability(Ca_buf[idx]);
        (*rvg)[idx].SetP(p);
    }
    
    if (myRank == MASTER_RANK)
    {
        #pragma omp barrier
        #pragma omp master
        {
            for (int idx = 0; idx < watchedAstroNum; idx++)
            {
                watchedProb.data[(iter + 1) * watchedAstroNum + idx] = (*rvg)[watchedAstroIdx[idx]].GetP();
            }
        }
        #pragma omp barrier
    }
}

template <typename T, typename RNGT>
inline T AstroNet<T, RNGT>::CumputeReleaseProbability(T Ca)
{
    // Ca <= CaBA                                 => p = p_basic;
    // Ca >= CaBA + (1 - p_basic) / CaRateRelease => p = 1.
    T p;
    if (Ca <= CaBA)
    {
        p = p_basic;
    }
    else
    {
        static T p0 = p_basic - CaRateRelease * CaBA;
        p = p0 + CaRateRelease * Ca;
        if (p > 1)
        {
            p = 1;
        }
    }
    return p;
}