#include "BasicCurrent.h"


// Second part of the midpoint method step
template <typename T>
void BasicCurrent<T>::DoOneStepPart2(const DistVector<T> &v_tmp)
{
    using namespace DistEnv;

    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(v_tmp.localLength, startIdx, endIdx);

    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T m_tmp = (this->*m_inf)(v_tmp[idx]);

        I[idx] = basicCurrentFactor * (c1 * pow(n_tmp[idx], 4) * (c2 - v_tmp[idx]) + c3 * pow(m_tmp, 3) * h_tmp[idx] * (c4 - v_tmp[idx]));

        T n_inc = ((this->*n_inf)(v_tmp[idx]) - n_tmp[idx]) / (this->*tau_n)(v_tmp[idx]);
        T h_inc = ((this->*h_inf)(v_tmp[idx]) - h_tmp[idx]) / (this->*tau_h)(v_tmp[idx]);

        n[idx] += dt * n_inc;
        h[idx] += dt * h_inc;
    }
}
