#include "GammaSimulator.h"

// Input vectors:        v_e_tmp, gts1_e, gts2_e, I_e, s_e_tmp, tau_r_e, tau_d_e, u_e
// Input scalars:        num_e, v_rev_e, v_rev_i, g_stoch_e, DeltaVGABA, GTonicGABA, VTonicGABA, dt, r_e, stoch_e_upd_const
// Input/output objects: basicCurrent_e, extraCurrent_e, modCurrent_e, voltageClamp_e
// Input/output vectors: v_e, s_e, s_stoch_e
template <typename T, typename RNGT>
void GammaSimulator<T, RNGT>::ElementwiseOperation3()
{
    using namespace DistEnv;

    if (enableBasicCurrent_e)
    {
        basicCurrent_e.DoOneStepPart2(v_e_tmp);
    }

    if (enableExtraCurrent_e)
    {
        extraCurrent_e.DoOneStepPart2(iter, v_e, v_e_tmp);
    }

    if (importMod_e)
    {
        modCurrent_e.DoOneStepPart2(iter, v_e, v_e_tmp);
    }

    int startIdx, endIdx;
    GetMyThreadChunkStartEndIdxs(v_e_tmp.localLength, startIdx, endIdx);

    for (int idx = startIdx; idx < endIdx; idx++)
    {
        T delta = v_rev_e - v_e_tmp[idx];
        
        T current_e = T(0.1) * (v_rplc_e - v_e_tmp[idx]) +
            gts1_e[idx] * delta + gts2_e[idx] * (gaba.DeltaVGABA + v_rev_i - v_e_tmp[idx]) + imageDrive[idx] +
            basicCurrent_e.I[idx] + I_e[idx] + extraCurrent_e.I[idx] + modCurrent_e.I[idx] +
            g_stoch_e * s_stoch_e[idx] * delta + gaba.AlphaTonic * gaba.GTonicGABA * (gaba.DeltaVGABA + gaba.VTonicGABA - v_e_tmp[idx]);
        
        T v_e_inc = voltageClamp_e.GetVoltageDer(current_e, idx, true, iter);
        
        T s_e_inc = T(0.5) * (1 + tanh(v_e_tmp[idx] / 4)) * (1 - s_e_tmp[idx]) / tau_r_e[idx] - s_e_tmp[idx] / tau_d_e[idx];
        
        v_e[idx] += dt * v_e_inc;
        s_e[idx] += dt * s_e_inc;
        
        T diff = stoch_e_upd_const - u_e[idx];
        if (diff > 0)
        {
            s_stoch_e[idx] = 1;
        }
        else
        {
            s_stoch_e[idx] *= r_e;
        }
    }
}